<?php
declare(strict_types=1);

require __DIR__ . '/controllers/SiteController.php';
require __DIR__ . '/controllers/AuthController.php';
require __DIR__ . '/controllers/PanelController.php';

$method = $_SERVER['REQUEST_METHOD'] ?? 'GET';
$path   = $GLOBALS['path'];

function dispatch_public(string $path, string $method): never {
  if ($path === '/' && $method === 'GET') { site_home(); exit; }
  if ($path === '/login' && $method === 'GET') { auth_login_form(); exit; }
  if ($path === '/login' && $method === 'POST') { auth_login_post(); exit; }
  if ($path === '/logout' && $method === 'POST') { auth_logout_post(); exit; }

  http_response_code(404);
  echo "404";
  exit;
}

function dispatch_panel(string $path, string $method): never {
  $sub = tenant_strip_prefix($path);

  $u = require_auth();
  $tenant = $GLOBALS['tenant'];
  if ((int)$u['company_id'] !== (int)$tenant['id']) {
    http_response_code(403);
    echo "Forbidden (wrong tenant)";
    exit;
  }

  /*
  |--------------------------------------------------------------------------
  | GET Routes
  |--------------------------------------------------------------------------
  */
  if ($method === 'GET') {
    if ($sub === '/' || $sub === '/dashboard') { panel_dashboard(); exit; }
    if ($sub === '/invoices') { panel_invoices(); exit; }
    if ($sub === '/quotes') { panel_quotes(); exit; }
    if ($sub === '/customers') { panel_customers(); exit; }
    if ($sub === '/products') { panel_products(); exit; }
    if ($sub === '/settings') { panel_settings(); exit; }
    if ($sub === '/company') { panel_company(); exit; }
    if ($sub === '/trash') { panel_trash(); exit; }
    if ($sub === '/create') { panel_create(); exit; }
  }

  /*
  |--------------------------------------------------------------------------
  | POST Routes
  |--------------------------------------------------------------------------
  */
  if ($method === 'POST') {
    // v0.2
    if ($sub === '/customers') { panel_customers_post(); exit; }
    if ($sub === '/products') { panel_products_post(); exit; }
    if ($sub === '/trash/restore') { panel_trash_restore_post(); exit; }
    if ($sub === '/trash/delete') { panel_trash_delete_post(); exit; }

    // v0.3 documents
    if ($sub === '/create') { panel_create_post(); exit; }
    if ($sub === '/documents/action') { panel_documents_post(); exit; }
  }

  http_response_code(404);
  echo "404";
  exit;
}

if ($GLOBALS['tenant']) dispatch_panel($path, $method);
dispatch_public($path, $method);
