<div class="flex items-center justify-between">
  <h2 class="text-lg font-semibold"><?= e(t('menu.create')) ?></h2>
</div>

<?php if (!empty($ok)): ?>
  <div class="mt-3 rounded-xl border border-emerald-200 bg-emerald-50 px-3 py-2 text-sm text-emerald-900 dark:border-emerald-900/40 dark:bg-emerald-950/30 dark:text-emerald-100">
    <?= e($ok) ?>
  </div>
<?php endif; ?>
<?php if (!empty($err)): ?>
  <div class="mt-3 rounded-xl border border-red-200 bg-red-50 px-3 py-2 text-sm text-red-900 dark:border-red-900/40 dark:bg-red-950/30 dark:text-red-100">
    <?= e($err) ?>
  </div>
<?php endif; ?>

<form method="post" class="mt-4 space-y-4">
  <input type="hidden" name="csrf" value="<?= e(csrf_token()) ?>">

  <div class="grid grid-cols-1 gap-3 md:grid-cols-3">
    <div>
      <label class="text-sm">Tür</label>
      <select name="type" class="mt-1 w-full rounded-xl border border-slate-200 bg-white px-3 py-2 dark:border-slate-800 dark:bg-slate-950">
        <option value="invoice">Fatura</option>
        <option value="quote">Teklif</option>
      </select>
    </div>
    <div>
      <label class="text-sm">Müşteri</label>
      <select name="customer_id" class="mt-1 w-full rounded-xl border border-slate-200 bg-white px-3 py-2 dark:border-slate-800 dark:bg-slate-950" required>
        <option value="">Seç</option>
        <?php foreach ($customers as $c): ?>
          <option value="<?= (int)$c['id'] ?>"><?= e((string)$c['name']) ?></option>
        <?php endforeach; ?>
      </select>
    </div>
    <div>
      <label class="text-sm">Para Birimi</label>
      <div class="mt-1 grid grid-cols-2 gap-2">
        <input name="currency" value="<?= e((string)$settings['default_currency']) ?>" class="w-full rounded-xl border border-slate-200 bg-white px-3 py-2 dark:border-slate-800 dark:bg-slate-950">
        <input name="currency_symbol" value="<?= e((string)$settings['default_currency_symbol']) ?>" class="w-full rounded-xl border border-slate-200 bg-white px-3 py-2 dark:border-slate-800 dark:bg-slate-950">
      </div>
    </div>
  </div>

  <div class="grid grid-cols-1 gap-3 md:grid-cols-3">
    <div>
      <label class="text-sm">Tarih</label>
      <input type="date" name="issue_date" value="<?= e(date('Y-m-d')) ?>" class="mt-1 w-full rounded-xl border border-slate-200 bg-white px-3 py-2 dark:border-slate-800 dark:bg-slate-950">
    </div>
    <div>
      <label class="text-sm">Vade</label>
      <input type="date" name="due_date" class="mt-1 w-full rounded-xl border border-slate-200 bg-white px-3 py-2 dark:border-slate-800 dark:bg-slate-950">
    </div>
    <div>
      <label class="text-sm">Kargo</label>
      <div class="mt-1 grid grid-cols-2 gap-2">
        <select name="shipping_mode" class="w-full rounded-xl border border-slate-200 bg-white px-3 py-2 dark:border-slate-800 dark:bg-slate-950">
          <option value="none">Yok</option>
          <option value="separate">Ayrı Toplam</option>
          <option value="line">Kalem Olarak</option>
        </select>
        <input name="shipping_amount" type="number" step="0.01" value="0" class="w-full rounded-xl border border-slate-200 bg-white px-3 py-2 dark:border-slate-800 dark:bg-slate-950">
      </div>
      <div class="mt-2">
        <label class="text-xs text-slate-500 dark:text-slate-400">Kargo KDV %</label>
        <input name="shipping_vat_rate" type="number" step="0.01" value="<?= e((string)$settings['default_vat_rate']) ?>"
          class="mt-1 w-full rounded-xl border border-slate-200 bg-white px-3 py-2 text-sm dark:border-slate-800 dark:bg-slate-950">
      </div>
    </div>
  </div>

  <!-- Kalemler -->
  <div class="rounded-2xl border border-slate-200 p-4 dark:border-slate-800">
    <div class="flex items-center justify-between">
      <div class="font-semibold">Kalemler</div>
      <button type="button" id="btnAdd" class="rounded-xl border border-slate-200 px-3 py-2 text-sm hover:bg-slate-50 dark:border-slate-800 dark:hover:bg-slate-900/50">
        + Satır Ekle
      </button>
    </div>

    <div class="mt-3 overflow-auto">
      <table class="min-w-full text-sm" id="itemsTable">
        <thead class="text-left text-xs text-slate-500 dark:text-slate-400">
          <tr>
            <th class="py-2 pr-2">Ürün/Hizmet</th>
            <th class="py-2 pr-2">Açıklama</th>
            <th class="py-2 pr-2">Miktar</th>
            <th class="py-2 pr-2">Birim</th>
            <th class="py-2 pr-2">Fiyat</th>
            <th class="py-2 pr-2">KDV %</th>
            <th class="py-2 pr-2"></th>
          </tr>
        </thead>
        <tbody id="itemsBody" class="divide-y divide-slate-100 dark:divide-slate-800"></tbody>
      </table>
    </div>
  </div>

  <div>
    <label class="text-sm">Notlar</label>
    <textarea name="notes" rows="3" class="mt-1 w-full rounded-xl border border-slate-200 bg-white px-3 py-2 dark:border-slate-800 dark:bg-slate-950"></textarea>
  </div>

  <button class="w-full rounded-xl bg-slate-900 px-4 py-2 text-white dark:bg-white dark:text-slate-900">
    Kaydet
  </button>
</form>

<script>
  const products = <?= json_encode($products, JSON_UNESCAPED_UNICODE) ?>;

  function rowTemplate(i){
    return `
      <tr>
        <td class="py-2 pr-2">
          <select name="items[${i}][name]" class="w-full rounded-lg border border-slate-200 bg-white px-2 py-2 dark:border-slate-800 dark:bg-slate-950">
            <option value="">Seç / Yaz</option>
            ${products.map(p => `<option value="${escapeHtml(p.name)}" data-unit="${escapeHtml(p.unit)}" data-price="${p.price}" data-vat="${p.vat_rate}">${escapeHtml(p.name)}</option>`).join('')}
          </select>
        </td>
        <td class="py-2 pr-2"><input name="items[${i}][description]" class="w-full rounded-lg border border-slate-200 bg-white px-2 py-2 dark:border-slate-800 dark:bg-slate-950"></td>
        <td class="py-2 pr-2"><input name="items[${i}][qty]" type="number" step="0.001" value="1" class="w-28 rounded-lg border border-slate-200 bg-white px-2 py-2 dark:border-slate-800 dark:bg-slate-950"></td>
        <td class="py-2 pr-2"><input name="items[${i}][unit]" value="adet" class="w-24 rounded-lg border border-slate-200 bg-white px-2 py-2 dark:border-slate-800 dark:bg-slate-950"></td>
        <td class="py-2 pr-2"><input name="items[${i}][unit_price]" type="number" step="0.01" value="0" class="w-32 rounded-lg border border-slate-200 bg-white px-2 py-2 dark:border-slate-800 dark:bg-slate-950"></td>
        <td class="py-2 pr-2"><input name="items[${i}][vat_rate]" type="number" step="0.01" value="20" class="w-24 rounded-lg border border-slate-200 bg-white px-2 py-2 dark:border-slate-800 dark:bg-slate-950"></td>
        <td class="py-2 pr-2">
          <button type="button" class="btnDel rounded-lg border border-slate-200 px-3 py-2 text-xs hover:bg-slate-50 dark:border-slate-800 dark:hover:bg-slate-900/50">Sil</button>
        </td>
      </tr>
    `;
  }

  function escapeHtml(s){
    return String(s ?? '').replace(/[&<>"']/g, m => ({'&':'&amp;','<':'&lt;','>':'&gt;','"':'&quot;',"'":'&#39;'}[m]));
  }

  let idx = 0;
  const body = document.getElementById('itemsBody');
  const btnAdd = document.getElementById('btnAdd');

  function addRow(){
    body.insertAdjacentHTML('beforeend', rowTemplate(idx));
    const tr = body.lastElementChild;
    const sel = tr.querySelector('select');

    sel.addEventListener('change', (e)=>{
      const opt = sel.options[sel.selectedIndex];
      if (!opt || !opt.dataset) return;
      const unit = opt.dataset.unit;
      const price = opt.dataset.price;
      const vat = opt.dataset.vat;
      if (unit) tr.querySelector(`[name="items[${idx}][unit]"]`)?.setAttribute('value', unit);
      tr.querySelector(`[name="items[${idx}][unit]"]`).value = unit || tr.querySelector(`[name="items[${idx}][unit]"]`).value;
      tr.querySelector(`[name="items[${idx}][unit_price]"]`).value = price ?? tr.querySelector(`[name="items[${idx}][unit_price]"]`).value;
      tr.querySelector(`[name="items[${idx}][vat_rate]"]`).value = vat ?? tr.querySelector(`[name="items[${idx}][vat_rate]"]`).value;
    });

    tr.querySelector('.btnDel').addEventListener('click', ()=> tr.remove());
    idx++;
  }

  btnAdd.addEventListener('click', addRow);
  addRow(); // ilk satır
</script>
