import { Injectable, NestMiddleware } from '@nestjs/common';
import { PrismaService } from '../prisma/prisma.service';

const PUBLIC_PATHS = new Set(['/giris', '/pricing', '/about', '/health']);

declare global {
  namespace Express {
    interface Request {
      companyId?: string;
      companySlug?: string;
    }
  }
}

@Injectable()
export class TenantMiddleware implements NestMiddleware {
  constructor(private prisma: PrismaService) {}

  async use(req: any, res: any, next: () => void) {
    const path = (req.path || '/').toLowerCase();

    // Public rotalar tenant değil
    if ([...PUBLIC_PATHS].some(p => path === p || path.startsWith(p + '/'))) {
      return next();
    }

    // /:firma/... yakala
    const seg = path.split('/').filter(Boolean)[0];
    if (!seg) return next();

    // Örn: /api altında çalışacaksan burayı ayır:
    // Eğer endpointlerin /api/... ise tenant path frontendde kalır.
    // Bu demo için doğrudan /:firma/... varsayıyorum.
    const company = await this.prisma.company.findUnique({ where: { slug: seg } });

    if (!company || !company.isActive) {
      return res.status(404).json({ message: 'Firma bulunamadı' });
    }

    req.companyId = company.id;
    req.companySlug = company.slug;
    next();
  }
}
