<?php
declare(strict_types=1);

function e(string $s): string {
  return htmlspecialchars($s, ENT_QUOTES, 'UTF-8');
}

function base_path(string $p=''): string {
  $app = $GLOBALS['app'];
  $base = rtrim((string)$app['base_url_path'], '/');
  return $base . $p;
}

function redirect(string $to): never {
  header('Location: ' . $to);
  exit;
}

function view(string $file, array $data=[]): void {
  extract($data, EXTR_SKIP);
  require __DIR__ . '/views/' . $file . '.php';
}

function t(string $key): string {
  $i18n = $GLOBALS['i18n'] ?? [];
  return (string)($i18n[$key] ?? $key);
}
function flash_set(string $key, string $msg): void {
  $_SESSION['flash'][$key] = $msg;
}
function flash_get(string $key): ?string {
  $v = $_SESSION['flash'][$key] ?? null;
  unset($_SESSION['flash'][$key]);
  return is_string($v) ? $v : null;
}