<h2 class="text-lg font-semibold">Faturalar</h2>

<?php if (!empty($ok)): ?><div class="mt-3 rounded-xl border border-emerald-200 bg-emerald-50 px-3 py-2 text-sm text-emerald-900 dark:border-emerald-900/40 dark:bg-emerald-950/30 dark:text-emerald-100"><?= e($ok) ?></div><?php endif; ?>
<?php if (!empty($err)): ?><div class="mt-3 rounded-xl border border-red-200 bg-red-50 px-3 py-2 text-sm text-red-900 dark:border-red-900/40 dark:bg-red-950/30 dark:text-red-100"><?= e($err) ?></div><?php endif; ?>

<div class="mt-4 flex items-center justify-between">
  <div class="text-sm text-slate-500 dark:text-slate-400"><?= count($rows ?? []) ?> kayıt</div>
  <a href="<?= e(base_path('/'.tenant_slug().'/create')) ?>" class="rounded-xl bg-slate-900 px-4 py-2 text-sm text-white dark:bg-white dark:text-slate-900">+ Yeni</a>
</div>

<div class="mt-3 overflow-auto">
  <table class="min-w-full text-sm">
    <thead class="text-left text-xs text-slate-500 dark:text-slate-400">
      <tr>
        <th class="py-2 pr-3">No</th>
        <th class="py-2 pr-3">Müşteri</th>
        <th class="py-2 pr-3">Tarih</th>
        <th class="py-2 pr-3">Toplam</th>
        <th class="py-2 pr-3">Durum</th>
        <th class="py-2 pr-3">İşlem</th>
      </tr>
    </thead>
    <tbody class="divide-y divide-slate-100 dark:divide-slate-800">
      <?php foreach (($rows ?? []) as $r): ?>
        <tr>
          <td class="py-2 pr-3 font-medium"><?= e((string)$r['doc_no']) ?></td>
          <td class="py-2 pr-3"><?= e((string)$r['customer_name']) ?></td>
          <td class="py-2 pr-3"><?= e((string)$r['issue_date']) ?></td>
          <td class="py-2 pr-3"><?= e((string)$r['currency_symbol']) ?> <?= number_format((float)$r['total'], 2, ',', '.') ?></td>
          <td class="py-2 pr-3"><?= e((string)$r['status']) ?></td>
          <td class="py-2 pr-3">
            <form method="post" action="<?= e(base_path('/'.tenant_slug().'/documents/action')) ?>" class="inline">
              <input type="hidden" name="csrf" value="<?= e(csrf_token()) ?>">
              <input type="hidden" name="action" value="trash">
              <input type="hidden" name="type" value="invoice">
              <input type="hidden" name="id" value="<?= (int)$r['id'] ?>">
              <button class="rounded-lg border border-slate-200 px-3 py-1 text-xs hover:bg-slate-50 dark:border-slate-800 dark:hover:bg-slate-900/50">Çöpe At</button>
            </form>
          </td>
        </tr>
      <?php endforeach; ?>
    </tbody>
  </table>

  <?php if (empty($rows)): ?>
    <div class="mt-4 text-sm text-slate-500 dark:text-slate-400">Henüz fatura yok.</div>
  <?php endif; ?>
</div>
