<?php
declare(strict_types=1);

$app = require __DIR__ . '/../config/app.php';
$db  = require __DIR__ . '/../config/database.php';

require __DIR__ . '/helpers.php';
require __DIR__ . '/db.php';
require __DIR__ . '/csrf.php';
require __DIR__ . '/i18n.php';
require __DIR__ . '/tenant.php';
require __DIR__ . '/auth.php';

$pdo = db($db);

session_name($app['session_name']);
ini_set('session.use_strict_mode', '1');
ini_set('session.cookie_httponly', '1');
// HTTPS varsa aç: ini_set('session.cookie_secure','1');
session_start();

/*
|--------------------------------------------------------------------------
| Path hesapla + Base path strip (subfolder kurulum için)
|--------------------------------------------------------------------------
*/

// Path
$path = parse_url($_SERVER['REQUEST_URI'] ?? '/', PHP_URL_PATH) ?: '/';
$path = rtrim($path, '/') ?: '/';

// Base path strip (ör: /fatura_teklif_saas/public)
$base = rtrim((string)($app['base_url_path'] ?? ''), '/');

if ($base !== '' && $base !== '/' && str_starts_with($path, $base)) {
    $path = substr($path, strlen($base));
    $path = $path === '' ? '/' : $path;
}

// Tenant resolve (artık temiz path ile)
$tenant = tenant_resolve($pdo, $path);

// i18n: tenant default + override (query ya da session)
$lang = $_GET['lang'] ?? ($_SESSION['lang'] ?? ($tenant['locale'] ?? 'tr'));
$lang = in_array($lang, ['tr','en'], true) ? $lang : 'tr';
$_SESSION['lang'] = $lang;

$i18n = i18n_load(__DIR__ . '/../lang', $lang);

// Global erişim
$GLOBALS['app']    = $app;
$GLOBALS['pdo']    = $pdo;
$GLOBALS['tenant'] = $tenant;
$GLOBALS['i18n']   = $i18n;
$GLOBALS['path']   = $path;
