<?php
declare(strict_types=1);

function csrf_token(): string {
  $key = $GLOBALS['app']['csrf_key'];
  if (empty($_SESSION[$key])) {
    $_SESSION[$key] = bin2hex(random_bytes(32));
  }
  return (string)$_SESSION[$key];
}

function csrf_verify(?string $token): bool {
  $key = $GLOBALS['app']['csrf_key'];
  return isset($_SESSION[$key]) && is_string($token) && hash_equals($_SESSION[$key], $token);
}
