<?php
declare(strict_types=1);

function i18n_load(string $dir, string $lang): array {
  $file = rtrim($dir,'/') . '/' . $lang . '.json';
  if (!is_file($file)) return [];
  $json = file_get_contents($file);
  $data = json_decode((string)$json, true);
  return is_array($data) ? $data : [];
}
