<div class="flex items-center justify-between gap-3">
  <h2 class="text-lg font-semibold"><?= e(t('menu.products')) ?></h2>
</div>

<?php if (!empty($ok)): ?>
  <div class="mt-3 rounded-xl border border-emerald-200 bg-emerald-50 px-3 py-2 text-sm text-emerald-900 dark:border-emerald-900/40 dark:bg-emerald-950/30 dark:text-emerald-100">
    <?= e($ok) ?>
  </div>
<?php endif; ?>
<?php if (!empty($err)): ?>
  <div class="mt-3 rounded-xl border border-red-200 bg-red-50 px-3 py-2 text-sm text-red-900 dark:border-red-900/40 dark:bg-red-950/30 dark:text-red-100">
    <?= e($err) ?>
  </div>
<?php endif; ?>

<div class="mt-4 grid grid-cols-1 gap-4 lg:grid-cols-[360px_1fr]">
  <!-- Add -->
  <div class="rounded-2xl border border-slate-200 p-4 dark:border-slate-800">
    <div class="font-semibold">Ürün / Hizmet Ekle</div>
    <form method="post" class="mt-3 space-y-3">
      <input type="hidden" name="csrf" value="<?= e(csrf_token()) ?>">
      <input type="hidden" name="action" value="create">

      <div>
        <label class="text-sm">Ad *</label>
        <input name="name" required class="mt-1 w-full rounded-xl border border-slate-200 bg-white px-3 py-2 dark:border-slate-800 dark:bg-slate-950">
      </div>

      <div>
        <label class="text-sm">Açıklama</label>
        <textarea name="description" rows="3" class="mt-1 w-full rounded-xl border border-slate-200 bg-white px-3 py-2 dark:border-slate-800 dark:bg-slate-950"></textarea>
      </div>

      <div class="grid grid-cols-3 gap-2">
        <div>
          <label class="text-sm">Birim</label>
          <input name="unit" value="adet" class="mt-1 w-full rounded-xl border border-slate-200 bg-white px-3 py-2 dark:border-slate-800 dark:bg-slate-950">
        </div>
        <div>
          <label class="text-sm">Fiyat</label>
          <input name="price" type="number" step="0.01" value="0" class="mt-1 w-full rounded-xl border border-slate-200 bg-white px-3 py-2 dark:border-slate-800 dark:bg-slate-950">
        </div>
        <div>
          <label class="text-sm">KDV %</label>
          <input name="vat_rate" type="number" step="0.01" value="20" class="mt-1 w-full rounded-xl border border-slate-200 bg-white px-3 py-2 dark:border-slate-800 dark:bg-slate-950">
        </div>
      </div>

      <button class="w-full rounded-xl bg-slate-900 px-4 py-2 text-white dark:bg-white dark:text-slate-900">
        Kaydet
      </button>
    </form>
  </div>

  <!-- List -->
  <div class="rounded-2xl border border-slate-200 p-4 dark:border-slate-800">
    <div class="flex items-center justify-between">
      <div class="font-semibold">Ürün / Hizmet Listesi</div>
      <div class="text-xs text-slate-500 dark:text-slate-400"><?= count($rows ?? []) ?> kayıt</div>
    </div>

    <div class="mt-3 overflow-auto">
      <table class="min-w-full text-sm">
        <thead class="text-left text-xs text-slate-500 dark:text-slate-400">
          <tr>
            <th class="py-2 pr-3">Ad</th>
            <th class="py-2 pr-3">Birim</th>
            <th class="py-2 pr-3">Fiyat</th>
            <th class="py-2 pr-3">KDV</th>
            <th class="py-2 pr-3">İşlem</th>
          </tr>
        </thead>
        <tbody class="divide-y divide-slate-100 dark:divide-slate-800">
        <?php foreach (($rows ?? []) as $r): ?>
          <tr>
            <td class="py-2 pr-3 font-medium"><?= e((string)$r['name']) ?></td>
            <td class="py-2 pr-3"><?= e((string)$r['unit']) ?></td>
            <td class="py-2 pr-3"><?= number_format((float)$r['price'], 2, ',', '.') ?></td>
            <td class="py-2 pr-3"><?= rtrim(rtrim(number_format((float)$r['vat_rate'],2,'.',''), '0'), '.') ?>%</td>
            <td class="py-2 pr-3">
              <form method="post" class="inline">
                <input type="hidden" name="csrf" value="<?= e(csrf_token()) ?>">
                <input type="hidden" name="action" value="trash">
                <input type="hidden" name="id" value="<?= (int)$r['id'] ?>">
                <button class="rounded-lg border border-slate-200 px-3 py-1 text-xs hover:bg-slate-50 dark:border-slate-800 dark:hover:bg-slate-900/50">
                  Çöpe At
                </button>
              </form>
            </td>
          </tr>
        <?php endforeach; ?>
        </tbody>
      </table>

      <?php if (empty($rows)): ?>
        <div class="mt-4 text-sm text-slate-500 dark:text-slate-400">Kayıt yok.</div>
      <?php endif; ?>
    </div>
  </div>
</div>
