<?php
declare(strict_types=1);

require __DIR__ . '/inc/db.php';
require __DIR__ . '/inc/auth.php';
require __DIR__ . '/inc/helpers.php';
require __DIR__ . '/inc/csrf.php';

require_login();
$uid = current_user_id();

// dropdown verileri
$accs = $pdo->prepare("SELECT id,name FROM accounts WHERE user_id=? AND deleted_at IS NULL AND is_active=1 ORDER BY name");
$accs->execute([$uid]);
$accounts = $accs->fetchAll();

$cats_income = $pdo->prepare("SELECT id,name FROM categories WHERE user_id=? AND type='income' AND deleted_at IS NULL AND is_active=1 ORDER BY name");
$cats_income->execute([$uid]);
$cats_income = $cats_income->fetchAll();

$cats_expense = $pdo->prepare("SELECT id,name FROM categories WHERE user_id=? AND type='expense' AND deleted_at IS NULL AND is_active=1 ORDER BY name");
$cats_expense->execute([$uid]);
$cats_expense = $cats_expense->fetchAll();

// liste
$q = trim((string)($_GET['q'] ?? ''));
$type = (string)($_GET['type'] ?? 'all');

$params = [$uid];
$where = "t.user_id=? AND t.deleted_at IS NULL";

if ($type !== 'all' && in_array($type, ['income','expense','transfer'], true)) {
  $where .= " AND t.type=?";
  $params[] = $type;
}
if ($q !== '') {
  $where .= " AND (t.description LIKE ?)";
  $params[] = "%{$q}%";
}

$st = $pdo->prepare("
  SELECT
    t.id, t.occurred_at, t.type, t.amount, t.description,
    t.category_id, t.account_id, t.from_account_id, t.to_account_id,
    c.name AS category_name,
    a.name AS account_name,
    af.name AS from_name,
    at.name AS to_name
  FROM transactions t
  LEFT JOIN categories c ON c.id=t.category_id
  LEFT JOIN accounts a ON a.id=t.account_id
  LEFT JOIN accounts af ON af.id=t.from_account_id
  LEFT JOIN accounts at ON at.id=t.to_account_id
  WHERE {$where}
  ORDER BY t.occurred_at DESC, t.id DESC
  LIMIT 200
");
$st->execute($params);
$rows = $st->fetchAll();
?>
<!doctype html>
<html lang="tr" class="h-full">
<head>
  <meta charset="utf-8" />
  <meta name="viewport" content="width=device-width,initial-scale=1" />
  <title>İşlemler • gelir_gider_v1</title>

  <script src="https://cdn.tailwindcss.com"></script>
  <script>tailwind.config={darkMode:'class'};</script>

  <link rel="stylesheet" href="assets/css/app.css" />
</head>

<body class="h-full bg-slate-50 text-slate-900 dark:bg-slate-950 dark:text-slate-100">
<div class="min-h-screen flex">

  <!-- MOBILE SIDEBAR -->
  <aside id="sidebar"
    class="fixed lg:static inset-y-0 left-0 z-50 w-72 -translate-x-full lg:translate-x-0 transition-transform
           bg-white/90 dark:bg-slate-950/90 backdrop-blur border-r border-slate-200 dark:border-slate-800">
    <div class="h-16 px-4 flex items-center justify-between border-b border-slate-200 dark:border-slate-800">
      <div class="flex items-center gap-3">
        <div class="h-10 w-10 rounded-2xl bg-slate-900 dark:bg-white flex items-center justify-center">
          <span class="text-white dark:text-slate-900 font-black">₺</span>
        </div>
        <div>
          <p class="font-semibold leading-5">gelir_gider_v1</p>
          <p class="text-xs muted">Panel</p>
        </div>
      </div>
      <button id="sidebarClose" class="btn lg:hidden" type="button">✕</button>
    </div>

    <nav class="p-3 space-y-1">
      <a class="nav-item" href="./">📊 Dashboard</a>
      <a class="nav-item nav-active" href="transactions.php">🧾 İşlemler</a>
      <a class="nav-item" href="accounts.php">🏦 Hesaplar</a>
      <a class="nav-item" href="categories.php">🏷️ Kategoriler</a>
      <a class="nav-item" href="goals.php">🎯 Hedefler</a>
      <a class="nav-item" href="#">📈 Yatırımlar</a>
      <div class="pt-3 mt-3 border-t border-slate-200 dark:border-slate-800">
        <a class="nav-item" href="logout.php">🚪 Çıkış</a>
      </div>
    </nav>
  </aside>

  <div id="overlay" class="fixed inset-0 bg-black/40 z-40 hidden lg:hidden"></div>

  <div class="flex-1">
    <!-- Topbar -->
    <header class="sticky top-0 z-30 border-b border-slate-200/70 dark:border-slate-800/70 bg-white/70 dark:bg-slate-950/70 backdrop-blur">
      <div class="mx-auto max-w-7xl px-4 sm:px-6 lg:px-8 py-3 flex items-center justify-between">
        <div class="flex items-center gap-2">
          <button id="sidebarOpen" class="btn lg:hidden" type="button">☰</button>
          <div>
            <p class="font-semibold leading-5">İşlemler</p>
            <p class="text-xs muted">Gelir • Gider • Transfer</p>
          </div>
        </div>

        <div class="flex items-center gap-2">
          <button id="themeToggle" class="btn" type="button" aria-label="Tema Değiştir">
            <span id="themeIcon">🌙</span>
            <span class="hidden sm:inline">Karanlık Mod</span>
          </button>

          <a class="btn" href="./">← Dashboard</a>
        </div>
      </div>
    </header>

    <main class="mx-auto max-w-7xl px-4 sm:px-6 lg:px-8 py-6 space-y-6">

      <!-- Add form -->
      <section class="card p-4">
        <div>
          <p class="font-semibold">İşlem Ekle</p>
          <p class="text-sm muted">Gelir / Gider / Transfer</p>
        </div>

        <form class="mt-4 grid grid-cols-1 md:grid-cols-12 gap-3" method="post" action="api/transactions.php">
          <input type="hidden" name="csrf" value="<?php echo htmlspecialchars(csrf_token()); ?>">
          <input type="hidden" name="action" value="create">

          <div class="md:col-span-2">
            <label class="text-sm font-medium">Tür</label>
            <select name="type" id="typeSel" class="sel w-full mt-1">
              <option value="expense">Gider</option>
              <option value="income">Gelir</option>
              <option value="transfer">Transfer</option>
            </select>
          </div>

          <div class="md:col-span-2">
            <label class="text-sm font-medium">Tarih</label>
            <input name="occurred_at" type="date" class="sel w-full mt-1" value="<?php echo date('Y-m-d'); ?>" required>
          </div>

          <div class="md:col-span-2">
            <label class="text-sm font-medium">Tutar (₺)</label>
            <input name="amount" type="number" step="0.01" min="0" class="sel w-full mt-1" required>
          </div>

          <div class="md:col-span-3" id="catWrap">
            <label class="text-sm font-medium">Kategori</label>
            <select name="category_id" id="catSel" class="sel w-full mt-1"></select>
          </div>

          <div class="md:col-span-3" id="accWrap">
            <label class="text-sm font-medium">Hesap</label>
            <select name="account_id" class="sel w-full mt-1">
              <?php foreach($accounts as $a): ?>
                <option value="<?php echo (int)$a['id']; ?>" class="bg-white dark:bg-slate-900">
                  <?php echo htmlspecialchars((string)$a['name']); ?>
                </option>
              <?php endforeach; ?>
            </select>
          </div>

          <div class="md:col-span-3 hidden" id="fromWrap">
            <label class="text-sm font-medium">Gönderen</label>
            <select name="from_account_id" class="sel w-full mt-1">
              <?php foreach($accounts as $a): ?>
                <option value="<?php echo (int)$a['id']; ?>" class="bg-white dark:bg-slate-900">
                  <?php echo htmlspecialchars((string)$a['name']); ?>
                </option>
              <?php endforeach; ?>
            </select>
          </div>

          <div class="md:col-span-3 hidden" id="toWrap">
            <label class="text-sm font-medium">Alan</label>
            <select name="to_account_id" class="sel w-full mt-1">
              <?php foreach($accounts as $a): ?>
                <option value="<?php echo (int)$a['id']; ?>" class="bg-white dark:bg-slate-900">
                  <?php echo htmlspecialchars((string)$a['name']); ?>
                </option>
              <?php endforeach; ?>
            </select>
          </div>

          <div class="md:col-span-12">
            <label class="text-sm font-medium">Açıklama</label>
            <input name="description" type="text" class="sel w-full mt-1" placeholder="Örn: Market / Maaş / Kira...">
          </div>

          <div class="md:col-span-12 flex items-center justify-end">
            <button class="btn" type="submit">✅ Kaydet</button>
          </div>
        </form>
      </section>

      <!-- Filters + table -->
      <section class="card p-4">
        <div class="flex flex-col md:flex-row md:items-center md:justify-between gap-3">
          <div>
            <p class="font-semibold">İşlem Listesi</p>
            <p class="text-sm muted">Son 200 kayıt</p>
          </div>

          <form class="flex gap-2" method="get">
            <select name="type" class="sel">
              <option value="all" <?php if($type==='all') echo 'selected'; ?>>Tümü</option>
              <option value="income" <?php if($type==='income') echo 'selected'; ?>>Gelir</option>
              <option value="expense" <?php if($type==='expense') echo 'selected'; ?>>Gider</option>
              <option value="transfer" <?php if($type==='transfer') echo 'selected'; ?>>Transfer</option>
            </select>
            <input name="q" value="<?php echo htmlspecialchars((string)$q); ?>" class="sel" placeholder="Ara (açıklama)">
            <button class="btn">Filtrele</button>
          </form>
        </div>

        <div class="mt-4 overflow-auto">
          <table class="w-full text-sm">
            <thead class="text-xs muted">
              <tr class="border-b border-slate-200 dark:border-slate-800">
                <th class="py-2 text-left font-medium">Tarih</th>
                <th class="py-2 text-left font-medium">Tür</th>
                <th class="py-2 text-left font-medium">Detay</th>
                <th class="py-2 text-right font-medium">Tutar</th>
                <th class="py-2 text-right font-medium">İşlem</th>
              </tr>
            </thead>
            <tbody class="divide-y divide-slate-200 dark:divide-slate-800">
              <?php foreach($rows as $r):
                $t = (string)$r['type'];
                $amt = (float)$r['amount'];
                $label = $t==='income'?'Gelir':($t==='expense'?'Gider':'Transfer');
                $badge = $t==='income'?'badge-pos':($t==='expense'?'badge-neg':'badge-neu');

                $detail = '';
                if ($t==='transfer') {
                  $detail = ($r['from_name'] ?? '-') . ' → ' . ($r['to_name'] ?? '-');
                } else {
                  $detail = ($r['category_name'] ?? '-') . ' • ' . ($r['account_name'] ?? '-');
                }
              ?>
              <tr class="hover:bg-slate-50 dark:hover:bg-slate-800/40"
                  data-id="<?php echo (int)$r['id']; ?>"
                  data-type="<?php echo htmlspecialchars((string)$r['type']); ?>"
                  data-date="<?php echo htmlspecialchars((string)$r['occurred_at']); ?>"
                  data-amount="<?php echo htmlspecialchars((string)$r['amount']); ?>"
                  data-desc="<?php echo htmlspecialchars((string)($r['description'] ?? '')); ?>"
                  data-category_id="<?php echo (int)($r['category_id'] ?? 0); ?>"
                  data-account_id="<?php echo (int)($r['account_id'] ?? 0); ?>"
                  data-from_account_id="<?php echo (int)($r['from_account_id'] ?? 0); ?>"
                  data-to_account_id="<?php echo (int)($r['to_account_id'] ?? 0); ?>"
              >
                <td class="py-2 pr-2 whitespace-nowrap muted"><?php echo htmlspecialchars((string)$r['occurred_at']); ?></td>
                <td class="py-2 pr-2"><span class="badge <?php echo $badge; ?>"><?php echo $label; ?></span></td>
                <td class="py-2 pr-2">
                  <div class="font-medium"><?php echo htmlspecialchars((string)$detail); ?></div>
                  <div class="text-xs muted"><?php echo htmlspecialchars((string)($r['description'] ?? '')); ?></div>
                </td>
                <td class="py-2 text-right font-semibold <?php echo $t==='expense'?'text-rose-600 dark:text-rose-400':'text-emerald-600 dark:text-emerald-400'; ?>">
                  <?php echo ($t==='expense' ? '-' : '+') . fmt_try($amt); ?>
                </td>
                <td class="py-2 text-right">
                  <div class="flex justify-end gap-2">
                    <button type="button" class="btn btn-edit">✏️</button>

                    <form method="post" action="api/transactions.php" onsubmit="return confirm('Silinsin mi?');">
                      <input type="hidden" name="csrf" value="<?php echo htmlspecialchars(csrf_token()); ?>">
                      <input type="hidden" name="action" value="delete">
                      <input type="hidden" name="id" value="<?php echo (int)$r['id']; ?>">
                      <button class="btn" type="submit">🗑️</button>
                    </form>
                  </div>
                </td>
              </tr>
              <?php endforeach; ?>

              <?php if (!$rows): ?>
                <tr><td colspan="5" class="py-6 text-center muted">Kayıt yok.</td></tr>
              <?php endif; ?>
            </tbody>
          </table>
        </div>
      </section>

    </main>
  </div>
</div>

<!-- EDIT MODAL -->
<div id="editModal" class="fixed inset-0 z-50 hidden">
  <div class="absolute inset-0 bg-black/50"></div>

  <div class="relative mx-auto max-w-2xl px-4 sm:px-6 lg:px-8 mt-10">
    <div class="card p-4">
      <div class="flex items-center justify-between">
        <div>
          <p class="font-semibold text-lg">İşlem Düzenle</p>
          <p class="text-xs muted">Gelir / Gider / Transfer</p>
        </div>
        <button id="editClose" class="btn" type="button">✕</button>
      </div>

      <form id="editForm" class="mt-4 grid grid-cols-1 md:grid-cols-12 gap-3" method="post" action="api/transactions.php">
        <input type="hidden" name="csrf" value="<?php echo htmlspecialchars(csrf_token()); ?>">
        <input type="hidden" name="action" value="update">
        <input type="hidden" name="id" id="e_id" value="0">

        <div class="md:col-span-2">
          <label class="text-sm font-medium">Tür</label>
          <select name="type" id="e_type" class="sel w-full mt-1">
            <option value="expense">Gider</option>
            <option value="income">Gelir</option>
            <option value="transfer">Transfer</option>
          </select>
        </div>

        <div class="md:col-span-2">
          <label class="text-sm font-medium">Tarih</label>
          <input name="occurred_at" id="e_date" type="date" class="sel w-full mt-1" required>
        </div>

        <div class="md:col-span-2">
          <label class="text-sm font-medium">Tutar (₺)</label>
          <input name="amount" id="e_amount" type="number" step="0.01" min="0" class="sel w-full mt-1" required>
        </div>

        <div class="md:col-span-3" id="e_catWrap">
          <label class="text-sm font-medium">Kategori</label>
          <select name="category_id" id="e_catSel" class="sel w-full mt-1"></select>
        </div>

        <div class="md:col-span-3" id="e_accWrap">
          <label class="text-sm font-medium">Hesap</label>
          <select name="account_id" id="e_account" class="sel w-full mt-1">
            <?php foreach($accounts as $a): ?>
              <option value="<?php echo (int)$a['id']; ?>" class="bg-white dark:bg-slate-900">
                <?php echo htmlspecialchars((string)$a['name']); ?>
              </option>
            <?php endforeach; ?>
          </select>
        </div>

        <div class="md:col-span-3 hidden" id="e_fromWrap">
          <label class="text-sm font-medium">Gönderen</label>
          <select name="from_account_id" id="e_from" class="sel w-full mt-1">
            <?php foreach($accounts as $a): ?>
              <option value="<?php echo (int)$a['id']; ?>" class="bg-white dark:bg-slate-900">
                <?php echo htmlspecialchars((string)$a['name']); ?>
              </option>
            <?php endforeach; ?>
          </select>
        </div>

        <div class="md:col-span-3 hidden" id="e_toWrap">
          <label class="text-sm font-medium">Alan</label>
          <select name="to_account_id" id="e_to" class="sel w-full mt-1">
            <?php foreach($accounts as $a): ?>
              <option value="<?php echo (int)$a['id']; ?>" class="bg-white dark:bg-slate-900">
                <?php echo htmlspecialchars((string)$a['name']); ?>
              </option>
            <?php endforeach; ?>
          </select>
        </div>

        <div class="md:col-span-12">
          <label class="text-sm font-medium">Açıklama</label>
          <input name="description" id="e_desc" type="text" class="sel w-full mt-1" placeholder="Örn: Market / Maaş / Kira...">
        </div>

        <div class="md:col-span-12 flex justify-end gap-2">
          <button class="btn" type="button" id="editCancel">Vazgeç</button>
          <button class="btn" type="submit">💾 Güncelle</button>
        </div>
      </form>
    </div>
  </div>
</div>

<script>
  // income/expense category switcher (create)
  const incomeCats = <?php echo json_encode($cats_income, JSON_UNESCAPED_UNICODE); ?>;
  const expenseCats = <?php echo json_encode($cats_expense, JSON_UNESCAPED_UNICODE); ?>;

  const typeSel = document.getElementById('typeSel');
  const catSel = document.getElementById('catSel');
  const catWrap = document.getElementById('catWrap');
  const accWrap = document.getElementById('accWrap');
  const fromWrap = document.getElementById('fromWrap');
  const toWrap = document.getElementById('toWrap');

  function fillCats(selectEl, list){
    selectEl.innerHTML = '';
    list.forEach(c=>{
      const opt=document.createElement('option');
      opt.value = c.id;
      opt.textContent = c.name;
      opt.className='bg-white dark:bg-slate-900';
      selectEl.appendChild(opt);
    });
  }

  function onType(){
    const t = typeSel.value;
    if (t === 'transfer') {
      catWrap.classList.add('hidden');
      accWrap.classList.add('hidden');
      fromWrap.classList.remove('hidden');
      toWrap.classList.remove('hidden');
    } else {
      catWrap.classList.remove('hidden');
      accWrap.classList.remove('hidden');
      fromWrap.classList.add('hidden');
      toWrap.classList.add('hidden');
      fillCats(catSel, t === 'income' ? incomeCats : expenseCats);
    }
  }

  fillCats(catSel, expenseCats);
  typeSel.addEventListener('change', onType);
  onType();

  // EDIT MODAL LOGIC
  const modal = document.getElementById('editModal');
  const closeBtn = document.getElementById('editClose');
  const cancelBtn = document.getElementById('editCancel');

  const e_id = document.getElementById('e_id');
  const e_type = document.getElementById('e_type');
  const e_date = document.getElementById('e_date');
  const e_amount = document.getElementById('e_amount');
  const e_desc = document.getElementById('e_desc');

  const e_catWrap = document.getElementById('e_catWrap');
  const e_accWrap = document.getElementById('e_accWrap');
  const e_fromWrap = document.getElementById('e_fromWrap');
  const e_toWrap = document.getElementById('e_toWrap');

  const e_catSel = document.getElementById('e_catSel');
  const e_account = document.getElementById('e_account');
  const e_from = document.getElementById('e_from');
  const e_to = document.getElementById('e_to');

  function openModal(){ modal.classList.remove('hidden'); }
  function closeModal(){ modal.classList.add('hidden'); }

  function editOnType(){
    const t = e_type.value;
    if (t === 'transfer') {
      e_catWrap.classList.add('hidden');
      e_accWrap.classList.add('hidden');
      e_fromWrap.classList.remove('hidden');
      e_toWrap.classList.remove('hidden');
    } else {
      e_catWrap.classList.remove('hidden');
      e_accWrap.classList.remove('hidden');
      e_fromWrap.classList.add('hidden');
      e_toWrap.classList.add('hidden');
      fillCats(e_catSel, t === 'income' ? incomeCats : expenseCats);
    }
  }

  document.querySelectorAll('.btn-edit').forEach(btn=>{
    btn.addEventListener('click', (ev)=>{
      const tr = ev.target.closest('tr');
      if (!tr) return;

      const t = tr.dataset.type;

      e_id.value = tr.dataset.id;
      e_type.value = t;
      e_date.value = tr.dataset.date;
      e_amount.value = tr.dataset.amount;
      e_desc.value = tr.dataset.desc || '';

      editOnType();

      if (t === 'transfer') {
        e_from.value = tr.dataset.from_account_id || '0';
        e_to.value = tr.dataset.to_account_id || '0';
      } else {
        // after fillCats
        const catId = tr.dataset.category_id || '0';
        const accId = tr.dataset.account_id || '0';
        if (catId !== '0') e_catSel.value = catId;
        if (accId !== '0') e_account.value = accId;
      }

      openModal();
    });
  });

  e_type.addEventListener('change', editOnType);
  closeBtn.addEventListener('click', closeModal);
  cancelBtn.addEventListener('click', closeModal);
  modal.addEventListener('click', (e)=>{ if (e.target === modal) closeModal(); });
</script>

<script src="assets/js/app.js"></script>
</body>
</html>
