// assets/js/app.js
(function () {
  const root = document.documentElement;

  // ---------- THEME ----------
  const themeToggle = document.getElementById("themeToggle");
  const themeIcon = document.getElementById("themeIcon");

  function applyTheme(mode) {
    const isDark = mode === "dark";
    root.classList.toggle("dark", isDark);
    try { localStorage.setItem("theme", isDark ? "dark" : "light"); } catch(e) {}
    if (themeIcon) themeIcon.textContent = isDark ? "☀️" : "🌙";
  }

  // init theme
  let saved = null;
  try { saved = localStorage.getItem("theme"); } catch(e) {}
  if (saved === "dark" || saved === "light") {
    applyTheme(saved);
  } else {
    const prefersDark = window.matchMedia && window.matchMedia("(prefers-color-scheme: dark)").matches;
    applyTheme(prefersDark ? "dark" : "light");
  }

  if (themeToggle) {
    themeToggle.addEventListener("click", (e) => {
      e.preventDefault();
      const isDark = root.classList.contains("dark");
      applyTheme(isDark ? "light" : "dark");
    });
  }

  // ---------- SIDEBAR (mobile) ----------
  const sidebar = document.getElementById("sidebar");
  const overlay = document.getElementById("overlay");
  const sidebarOpen = document.getElementById("sidebarOpen");
  const sidebarClose = document.getElementById("sidebarClose");

  function openSidebar() {
    if (!sidebar || !overlay) return;
    sidebar.classList.remove("-translate-x-full");
    overlay.classList.remove("hidden");
  }
  function closeSidebar() {
    if (!sidebar || !overlay) return;
    sidebar.classList.add("-translate-x-full");
    overlay.classList.add("hidden");
  }

  if (sidebarOpen) sidebarOpen.addEventListener("click", (e) => { e.preventDefault(); openSidebar(); });
  if (sidebarClose) sidebarClose.addEventListener("click", (e) => { e.preventDefault(); closeSidebar(); });
  if (overlay) overlay.addEventListener("click", (e) => { e.preventDefault(); closeSidebar(); });

  // ---------- QUICK ACTION MENU ----------
  const qaBtn = document.getElementById("quickActionBtn");
  const qaMenu = document.getElementById("quickActionMenu");

  function closeQa() {
    if (!qaMenu) return;
    qaMenu.classList.add("hidden");
  }
  function toggleQa() {
    if (!qaMenu) return;
    qaMenu.classList.toggle("hidden");
  }

  if (qaBtn) {
    qaBtn.addEventListener("click", (e) => {
      e.preventDefault();
      e.stopPropagation();
      toggleQa();
    });
  }

  document.addEventListener("click", () => closeQa());
  if (qaMenu) qaMenu.addEventListener("click", (e) => e.stopPropagation());
})();
