<?php
declare(strict_types=1);
$config = require __DIR__ . '/config.php';
?>
<!doctype html>
<html lang="tr" class="h-full">
<head>
  <meta charset="utf-8">
  <title><?= h($config['app_name']) ?></title>
  <meta name="viewport" content="width=device-width, initial-scale=1">

  <!-- Dark mode: apply ASAP (before paint) -->
  <script>
    (function () {
      const saved = localStorage.getItem('theme');
      const prefersDark = window.matchMedia && window.matchMedia('(prefers-color-scheme: dark)').matches;
      if (saved === 'dark' || (!saved && prefersDark)) document.documentElement.classList.add('dark');
    })();
  </script>

  <!-- Tailwind CDN -->
  <script src="https://cdn.tailwindcss.com"></script>
  <script>
    tailwind.config = {
      darkMode: 'class',
      theme: {
        extend: {
          colors: { primary: '#089f99' }
        }
      }
    }
  </script>

  <link rel="stylesheet" href="<?= h(asset_url('app.css')) ?>">
</head>

<body class="h-full bg-slate-100 dark:bg-slate-900 text-slate-800 dark:text-slate-200">
<div class="min-h-full flex">

  <!-- Mobile overlay -->
  <div id="sbOverlay" class="fixed inset-0 bg-black/40 hidden z-40 lg:hidden"></div>

  <!-- SIDEBAR -->
  <aside id="sidebar"
         class="fixed z-50 lg:static inset-y-0 left-0 w-72 lg:w-72
                -translate-x-full lg:translate-x-0 transition-transform
                bg-white dark:bg-slate-950 border-r border-slate-200 dark:border-slate-800">
    <div class="px-4 py-4 flex items-center justify-between border-b border-slate-200 dark:border-slate-800">
      <div class="font-bold"><?= h($config['app_name']) ?></div>
      <button id="sbClose" class="lg:hidden px-2 py-1 rounded-lg bg-slate-100 dark:bg-slate-800">✕</button>
    </div>

    <nav class="p-3 text-sm">
      <a class="block px-3 py-2 rounded-xl hover:bg-slate-100 dark:hover:bg-slate-900"
         href="<?= h(page_url('index.php')) ?>">📊 Dashboard</a>

      <a class="block px-3 py-2 rounded-xl hover:bg-slate-100 dark:hover:bg-slate-900"
         href="<?= h(page_url('accounts.php')) ?>">🏦 Hesaplar</a>

      <a class="block px-3 py-2 rounded-xl hover:bg-slate-100 dark:hover:bg-slate-900"
         href="<?= h(page_url('transactions.php')) ?>">🧾 İşlemler</a>

      <a class="block px-3 py-2 rounded-xl hover:bg-slate-100 dark:hover:bg-slate-900"
         href="<?= h(page_url('transfers.php')) ?>">🔁 Transferler</a>

      <a class="block px-3 py-2 rounded-xl hover:bg-slate-100 dark:hover:bg-slate-900"
         href="<?= h(page_url('investments_trades.php')) ?>">📈 Yatırımlar</a>

      <a class="block px-3 py-2 rounded-xl hover:bg-slate-100 dark:hover:bg-slate-900"
         href="<?= h(page_url('goals.php')) ?>">🎯 Hedefler</a>

      <a class="block px-3 py-2 rounded-xl hover:bg-slate-100 dark:hover:bg-slate-900"
         href="<?= h(page_url('reports.php')) ?>">📄 Raporlar</a>

      <a class="block px-3 py-2 rounded-xl hover:bg-slate-100 dark:hover:bg-slate-900"
         href="<?= h(page_url('categories.php')) ?>">🏷️ Kategoriler</a>

      <a class="block px-3 py-2 rounded-xl hover:bg-slate-100 dark:hover:bg-slate-900"
         href="<?= h(page_url('trash.php')) ?>">🗑️ Çöp Kutusu</a>
    </nav>
  </aside>

  <!-- MAIN WRAP -->
  <div class="flex-1 flex flex-col min-w-0">

    <!-- TOPBAR -->
    <header class="sticky top-0 z-30 bg-slate-100/80 dark:bg-slate-900/70 backdrop-blur
                   border-b border-slate-200 dark:border-slate-800">
      <div class="px-4 py-3 flex items-center gap-3">
        <button id="sbOpen"
                class="lg:hidden px-3 py-2 rounded-xl bg-white dark:bg-slate-950 border border-slate-200 dark:border-slate-800">
          ☰
        </button>

        <div class="flex-1">
          <div class="text-xs opacity-70">Hoş geldin</div>
          <div class="font-semibold">Genel Bakış</div>
        </div>

        <button id="themeToggle"
          class="px-3 py-2 rounded-xl bg-white dark:bg-slate-950 border border-slate-200 dark:border-slate-800 text-sm">
          🌙 / ☀️
        </button>
      </div>
    </header>

    <!-- CONTENT -->
    <main class="flex-1 px-4 py-6 max-w-7xl w-full mx-auto">









