<?php
declare(strict_types=1);

require __DIR__ . '/../inc/db.php';
require __DIR__ . '/../inc/auth.php';
require __DIR__ . '/../inc/functions.php';
require __DIR__ . '/../inc/backup_lib.php';

$uid = function_exists('require_user_id') ? require_user_id($pdo) : (current_user_id() ?? 0);
if ($uid <= 0) { http_response_code(401); echo "unauthorized"; exit; }

$f = (string)($_GET['f'] ?? '');
$f = basename($f);

$path = backup_dir() . DIRECTORY_SEPARATOR . $f;
if ($f === '' || !is_file($path)) { http_response_code(404); echo "not found"; exit; }

header('Content-Type: application/sql');
header('Content-Disposition: attachment; filename="'.$f.'"');
header('Content-Length: ' . filesize($path));
readfile($path);
exit;
