<?php
require_once __DIR__ . '/../app/auth.php';
require_once __DIR__ . '/../app/security.php';
$u = require_auth();
$cashierLabel = ($u['role'] ?? '') === 'admin' ? 'Admin' : 'Kasiyer';
$cashierName = $cashierLabel . ': ' . ($u['full_name'] ?? $u['username']);
$avatar = strtoupper(mb_substr(($u['full_name'] ?? $u['username']), 0, 1, 'UTF-8'));
?>
<!DOCTYPE html>
<html lang="tr" data-theme="light" data-accent="blue">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0" />
  <title>POS Hızlı Satış</title>
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
  <script src="https://cdn.tailwindcss.com"></script>
  <style>
    :root {
      --primary: #3b82f6;
      --primary-dark: #1d4ed8;
      --surface: #ffffff;
      --background: #f8fafc;
      --text-primary: #1e293b;
      --text-secondary: #64748b;
      --border: #e2e8f0;
      --success: #10b981;
      --danger: #ef4444;
      --warning: #f59e0b;
    }

    [data-theme="dark"] {
      --surface: #1e293b;
      --background: #0f172a;
      --text-primary: #f1f5f9;
      --text-secondary: #cbd5e1;
      --border: #334155;
    }

    [data-accent="orange"] { --primary: #f97316; --primary-dark: #ea580c; }
    [data-accent="green"]  { --primary: #22c55e; --primary-dark: #16a34a; }
    [data-accent="purple"] { --primary: #8b5cf6; --primary-dark: #7c3aed; }

    body {
      background-color: var(--background);
      color: var(--text-primary);
      transition: background-color 0.3s, color 0.3s;
    }

    .touch-target { min-height: 48px; min-width: 48px; }

    .product-card { transition: transform 0.1s, box-shadow 0.1s; }
    .product-card:active { transform: scale(0.98); }

    .numpad-key { transition: all 0.1s; }
    .numpad-key:active { background-color: var(--primary); color: white; }

    .toast { animation: slideIn 0.3s ease-out; }
    @keyframes slideIn {
      from { transform: translateY(-100%); opacity: 0; }
      to { transform: translateY(0); opacity: 1; }
    }

    /* Sidebar (overlay on ALL sizes) */
    .sidebar {
      position: fixed;
      top: 0;
      bottom: 0;
      left: 0;
      z-index: 60;
      transition: transform 0.25s ease;
      transform: translateX(-100%);
      will-change: transform;
    }
    .sidebar.open { transform: translateX(0); }

    /* Always show overlay only when sidebar open */
    #sidebarOverlay { z-index: 55; }

    /* Mobile cart */
    @media (max-width: 768px) {
      .cart-panel {
        position: fixed;
        bottom: 0;
        left: 0;
        right: 0;
        height: 62vh;
        transform: translateY(100%);
        transition: transform 0.25s ease;
        z-index: 55;
        background: var(--surface);
      }
      .cart-panel.open { transform: translateY(0); }
    }

    /* Category tabs: wrap instead of horizontal scrollbar */
    #categoryTabs { overflow: visible; }

    /* Payment drawer button */
    .pay-open-btn { transition: transform 0.12s ease; }
    .pay-open-btn:active { transform: scale(0.98); }

    /* Modal-only helpers */
    .modal-only { display: none; }
    #paymentDock.in-modal .modal-only { display: flex; }

    /* Hide payment expand actions on cramped viewports */
    @media (max-height: 820px), (max-width: 1200px) {
      #paymentExpandBtn { display: none !important; }
    }

    /* Compact payment mode */
    @media (max-height: 820px) {
      #paymentDock { display: none !important; }
      #paymentFullArea { display: none !important; }
      #paymentCompactBar { display: block !important; }
    }
    
    /* When paymentDock is moved into modal, force it visible even in compact mode */
    #paymentDock.in-modal { display: block !important; }
    #paymentFullArea.in-modal { display: block !important; }

    /* Accent dropdown */
    .accent-dropdown { min-width: 140px; }

    /* Edit product modal */
    #productEditModal .tab-content { display: none; }
    #productEditModal .tab-content.active { display: block; }
  </style>
</head>
<body class="h-screen overflow-hidden">
  <div id="app" class="h-full flex flex-col">

    <!-- Header -->
    <header class="bg-[var(--surface)] border-b border-[var(--border)] p-4 flex items-center justify-between shadow-sm">
      <div class="flex items-center space-x-4">
        <button id="menuToggle" class="touch-target p-2 rounded-lg hover:bg-[var(--background)]" aria-label="Menu">
          <i class="fas fa-bars text-xl"></i>
        </button>
        <h1 class="text-2xl font-bold" data-i18n="pos.title">POS Hızlı Satış</h1>
        <div class="hidden md:flex items-center space-x-2">
          <span id="printerStatus" class="px-2 py-1 rounded text-sm bg-green-100 text-green-800">
            <i class="fas fa-print mr-1"></i><span data-i18n="pos.printer">Yazıcı Bağlı</span>
          </span>
          <span id="connectionStatus" class="px-2 py-1 rounded text-sm bg-blue-100 text-blue-800">
            <i class="fas fa-wifi mr-1"></i><span data-i18n="pos.online">Çevrimiçi</span>
          </span>
        </div>
      </div>

      <div class="flex items-center space-x-4">
        <!-- Dil Seçici -->
        <div class="flex items-center space-x-2">
          <button id="langTR" class="lang-btn px-3 py-1 rounded border border-[var(--border)] bg-[var(--surface)]">TR</button>
          <button id="langEN" class="lang-btn px-3 py-1 rounded border border-[var(--border)] bg-[var(--background)]">EN</button>
        </div>

        <!-- Tema Seçici -->
        <div class="flex items-center space-x-2">
          <button data-theme="light" class="theme-btn p-2 rounded-full hover:bg-[var(--background)]" aria-label="Light">
            <i class="fas fa-sun"></i>
          </button>
          <button data-theme="dark" class="theme-btn p-2 rounded-full hover:bg-[var(--background)]" aria-label="Dark">
            <i class="fas fa-moon"></i>
          </button>
        </div>

        <!-- Accent Color Dropdown -->
        <div class="relative">
          <button id="accentDropdownBtn" class="flex items-center space-x-2 p-2 rounded-lg border border-[var(--border)] hover:bg-[var(--background)]">
            <div class="w-6 h-6 rounded-full bg-[var(--primary)]"></div>
            <span class="text-sm" data-i18n="pos.accent">Renk</span>
            <i class="fas fa-chevron-down text-xs"></i>
          </button>
          <div id="accentDropdown" class="hidden absolute right-0 mt-2 rounded-lg border border-[var(--border)] bg-[var(--surface)] shadow-lg z-50 accent-dropdown">
            <button data-accent="blue" class="w-full text-left px-4 py-3 hover:bg-[var(--background)] flex items-center gap-3">
              <div class="w-6 h-6 rounded-full bg-blue-500"></div>
              <span>Mavi</span>
            </button>
            <button data-accent="orange" class="w-full text-left px-4 py-3 hover:bg-[var(--background)] flex items-center gap-3">
              <div class="w-6 h-6 rounded-full bg-orange-500"></div>
              <span>Turuncu</span>
            </button>
            <button data-accent="green" class="w-full text-left px-4 py-3 hover:bg-[var(--background)] flex items-center gap-3">
              <div class="w-6 h-6 rounded-full bg-green-500"></div>
              <span>Yeşil</span>
            </button>
            <button data-accent="purple" class="w-full text-left px-4 py-3 hover:bg-[var(--background)] flex items-center gap-3">
              <div class="w-6 h-6 rounded-full bg-purple-500"></div>
              <span>Mor</span>
            </button>
          </div>
        </div>

        <!-- Kullanıcı / Profil -->
        <div class="relative">
          <button id="userMenuBtn" class="flex items-center space-x-2 rounded-lg px-2 py-1 hover:bg-[var(--background)]">
            <span class="text-sm" id="cashierName"><?= e($cashierName) ?></span>
            <div class="w-8 h-8 rounded-full bg-[var(--primary)] text-white flex items-center justify-center"><?= e($avatar) ?></div>
            <i class="fas fa-chevron-down text-xs text-[var(--text-secondary)]"></i>
          </button>
          <div id="userMenu" class="hidden absolute right-0 mt-2 w-48 rounded-lg border border-[var(--border)] bg-[var(--surface)] shadow-lg overflow-hidden z-50">
            <button id="profileBtn" class="w-full text-left px-4 py-3 hover:bg-[var(--background)]">
              <i class="fas fa-user mr-2 text-[var(--text-secondary)]"></i><span data-i18n="pos.profile">Profil</span>
            </button>
            <?php if (($u['role'] ?? '') === 'admin'): ?>
            <a href="admin/users.php" class="block w-full text-left px-4 py-3 hover:bg-[var(--background)]">
              <i class="fas fa-user-shield mr-2 text-[var(--text-secondary)]"></i>Admin Panel
            </a>
            <?php endif; ?>
            <button id="logoutBtn" class="w-full text-left px-4 py-3 hover:bg-[var(--background)]">
              <i class="fas fa-right-from-bracket mr-2 text-[var(--text-secondary)]"></i><span data-i18n="pos.logout">Çıkış</span>
            </button>
          </div>
        </div>
      </div>
    </header>

    <!-- Main Content -->
    <div class="flex flex-1 overflow-hidden">

      <!-- Sidebar -->
      <div id="sidebarOverlay" class="hidden fixed inset-0 bg-black/40 z-50"></div>
      <aside id="sidebar" class="sidebar w-64 bg-[var(--surface)] border-r border-[var(--border)] overflow-y-auto shadow-lg">
        <nav class="p-4 space-y-4">
          <ul class="space-y-2">
            <li>
              <a href="#" class="flex items-center space-x-3 p-3 rounded-lg bg-[var(--primary)] text-white">
                <i class="fas fa-bolt"></i>
                <span data-i18n="pos.fastSale">Hızlı Satış</span>
              </a>
            </li>
            <li>
              <a href="#" class="flex items-center space-x-3 p-3 rounded-lg hover:bg-[var(--background)]">
                <i class="fas fa-pause"></i>
                <span data-i18n="pos.heldReceipts">Bekletilen Fişler</span>
              </a>
            </li>
            <li>
              <a href="#" class="flex items-center space-x-3 p-3 rounded-lg hover:bg-[var(--background)]">
                <i class="fas fa-chart-bar"></i>
                <span data-i18n="pos.dayEnd">Gün Sonu</span>
              </a>
            </li>
            <li>
              <a href="#" class="flex items-center space-x-3 p-3 rounded-lg hover:bg-[var(--background)]">
                <i class="fas fa-users"></i>
                <span data-i18n="pos.customers">Cariler</span>
              </a>
            </li>
            <li>
              <a href="#" class="flex items-center space-x-3 p-3 rounded-lg hover:bg-[var(--background)]">
                <i class="fas fa-cog"></i>
                <span data-i18n="pos.settings">Ayarlar</span>
              </a>
            </li>
          </ul>

          <!-- Sistem Durumu / Araçlar -->
          <div class="rounded-lg border border-[var(--border)] bg-[var(--background)] p-3">
            <div class="text-xs font-semibold tracking-wide text-[var(--text-secondary)]" data-i18n="pos.system">SİSTEM DURUMU</div>
            <div class="mt-3 flex items-center justify-between">
              <div class="text-sm" data-i18n="pos.reorder">Ürünleri düzenle</div>
              <label class="inline-flex items-center cursor-pointer">
                <input id="reorderToggle" type="checkbox" class="sr-only">
                <span class="w-10 h-6 bg-gray-300 rounded-full relative transition">
                  <span id="reorderKnob" class="absolute left-1 top-1 w-4 h-4 bg-white rounded-full transition"></span>
                </span>
              </label>
            </div>
            <p class="mt-2 text-xs text-[var(--text-secondary)]" data-i18n="pos.reorderHint">Açıkken ürün kartlarını sürükleyip bırakabilirsiniz.</p>
          </div>
        </nav>
      </aside>

      <!-- Main Area -->
      <main class="flex-1 flex overflow-hidden">

        <!-- Ürün Alanı -->
        <div class="flex-1 p-4 overflow-y-auto">

          <!-- Arama ve Cari -->
          <div class="mb-6 space-y-4">
            <div class="flex flex-col lg:flex-row gap-3">
              <div class="flex-1">
                <div class="relative">
                  <i class="fas fa-search absolute left-3 top-3 text-[var(--text-secondary)]"></i>
                  <input type="text" id="searchInput"
                         class="w-full pl-10 pr-4 py-3 rounded-lg border border-[var(--border)] bg-[var(--surface)]"
                         placeholder="Ürün ara veya barkod oku..." data-i18n-placeholder="pos.search">
                </div>
                <p class="mt-1 text-xs text-[var(--text-secondary)]" data-i18n="pos.searchHint">Arama alanına çift tıklayın → sayısal klavye açılır.</p>
              </div>

              <div class="w-full lg:w-[200px]">
                <div class="relative">
                  <div class="flex items-center gap-2">
                    <div class="flex-1 relative">
                      <i class="fas fa-user-tag absolute left-3 top-3 text-[var(--text-secondary)]"></i>
                      <input id="customerSearch" type="text"
                             class="w-full pl-10 pr-4 py-3 rounded-lg border border-[var(--border)] bg-[var(--surface)]"
                             placeholder="Müşteri adı / Vergi No ara..." data-i18n-placeholder="pos.customerSearch">
                      <div id="customerDropdown" class="hidden absolute left-0 right-0 mt-2 rounded-lg border border-[var(--border)] bg-[var(--surface)] shadow-lg z-40 max-h-64 overflow-auto"></div>
                    </div>
                    <button id="newCustomerBtn" class="touch-target px-4 py-3 rounded-lg bg-[var(--primary)] text-white hover:bg-[var(--primary-dark)]" title="Yeni Cari">
                      <i class="fas fa-plus"></i>
                    </button>
                  </div>
                  <div id="currentCustomerBadge" class="hidden mt-2 text-xs rounded-lg border border-[var(--border)] bg-[var(--background)] px-3 py-2 flex items-center justify-between">
                    <div>
                      <span class="font-semibold" id="currentCustomerName">—</span>
                      <span class="text-[var(--text-secondary)]" id="currentCustomerMeta"></span>
                    </div>
                    <button id="clearCustomer" class="px-2 py-1 rounded hover:bg-[var(--surface)]" title="Temizle">
                      <i class="fas fa-xmark"></i>
                    </button>
                  </div>
                </div>
              </div>
            </div>

            <!-- Kategori Tabları ve Ürün Ekle Butonu -->
            <div class="flex items-center justify-between gap-2">
              <div class="flex flex-wrap gap-2 flex-1" id="categoryTabs">
                <!-- tabs JS -->
              </div>
              <button id="addProductBtn" class="px-4 py-2 rounded-lg bg-[var(--primary)] text-white hover:bg-[var(--primary-dark)] flex items-center gap-2 whitespace-nowrap">
                <i class="fas fa-plus"></i>
                <span data-i18n="pos.addProduct">Ürün Ekle</span>
              </button>
            </div>
          </div>

          <!-- Ürün Grid -->
          <div id="productGrid" class="grid grid-cols-2 md:grid-cols-3 lg:grid-cols-4 xl:grid-cols-5 gap-4">
            <!-- Ürün kartları JS -->
          </div>
        </div>

        <!-- Sepet ve Ödeme Alanı (desktop) -->
        <div class="cart-panel w-96 border-l border-[var(--border)] flex flex-col" id="cartPanel">

          <!-- Sepet -->
          <div class="flex-1 p-4 overflow-y-auto">
            <div class="flex items-center justify-between mb-2">
              <h2 class="text-lg font-bold" data-i18n="pos.cart">SEPET</h2>
              <span id="itemCount" class="px-2 py-1 rounded-full bg-[var(--primary)] text-white text-sm">0 ürün</span>
            </div>
            <div class="mt-3 space-y-2">
              <div class="relative">
                <i class="fas fa-barcode absolute left-3 top-3 text-[var(--text-secondary)]"></i>
                <input type="text" id="barcodeInput"
                       class="w-full pl-10 pr-4 py-3 rounded-lg border border-[var(--border)] bg-[var(--surface)]"
                       placeholder="Barkod okut / yaz..." data-i18n-placeholder="pos.barcode">
              </div>
              <p class="text-xs text-[var(--text-secondary)]" data-i18n="pos.searchHint">Barkod alanına çift tıklayın → sayısal klavye açılır.</p>
            </div>

            <div id="cartItems" class="space-y-2">
              <div class="text-center py-12 text-[var(--text-secondary)]">
                <i class="fas fa-shopping-cart text-4xl mb-4"></i>
                <p data-i18n="pos.cart.empty">Sepet boş - ürün seçin</p>
              </div>
            </div>
          </div>

          <div class="border-t border-[var(--border)] p-4 bg-[var(--surface)] relative" style="position: sticky; bottom: 0;">
  
            <div id="paymentDock">
            <div class="space-y-3 mb-4">
              <div class="flex justify-between">
                <span data-i18n="pos.subtotal">Ara Toplam:</span>
                <span id="subtotal">0.00 ₺</span>
              </div>

              <!-- Detay satırları: sadece Ödeme İşlemleri ekranında (modal) gösterilir -->
              <div class="modal-only justify-between text-sm text-[var(--text-secondary)]" id="customerDiscountRow">
                <span data-i18n="pos.customerDiscount">Cari İndirimi:</span>
                <span id="customerDiscountAmount">-0.00 ₺</span>
              </div>
              <div class="modal-only justify-between text-sm text-[var(--text-secondary)]" id="lineDiscountRow">
                <span data-i18n="pos.lineDiscount">Satır İndirimi:</span>
                <span id="lineDiscountAmount">-0.00 ₺</span>
              </div>
              <div class="modal-only justify-between text-sm text-[var(--text-secondary)]" id="campaignDiscountRow">
                <span data-i18n="pos.campaignDiscount">Kampanya İndirimi:</span>
                <span id="campaignDiscountAmount">-0.00 ₺</span>
              </div>
              <div class="modal-only justify-between text-sm text-[var(--text-secondary)]" id="giftDiscountRow">
                <span data-i18n="pos.giftDiscount">Hediye:</span>
                <span id="giftDiscountAmount">-0.00 ₺</span>
              </div>

              <div id="discountRow" class="hidden justify-between text-sm text-[var(--text-secondary)]">
                <span data-i18n="pos.discount">Toplam İndirim:</span>
                <span id="discount">0.00 ₺</span>
              </div>

              <div class="flex justify-between text-sm text-[var(--text-secondary)]">
                <span data-i18n="pos.taxLine">Toplam KDV:</span>
                <span id="tax">0.00 ₺</span>
              </div>
              <div class="flex justify-between text-lg font-bold border-t border-[var(--border)] pt-3">
                <span data-i18n="pos.totalLine">GENEL TOPLAM:</span>
                <span id="total">0.00 ₺</span>
              </div>
            </div></div>
            <div id="paymentFullArea" class="payment-full hidden">
            <!-- Ödeme Tutarı -->
            <div class="mb-4">
              <label class="block text-sm mb-2" data-i18n="pos.paymentAmount">Ödeme Tutarı</label>
              <input type="text" id="paymentAmount"
                     class="w-full px-4 py-3 text-2xl font-bold rounded-lg border-2 border-[var(--primary)] bg-[var(--surface)] text-right"
                     value="0,00">
              <p class="mt-1 text-xs text-[var(--text-secondary)]" data-i18n="pos.paymentHint">Tutar alanına tıkla → klavye açılır.</p>
            </div>

            <!-- Hızlı Ödeme Butonları -->
            <div class="grid grid-cols-2 gap-2 mb-4">
              <button class="payment-btn p-4 rounded-lg bg-green-500 text-white font-bold hover:bg-green-600" data-pay="cash">
                <i class="fas fa-money-bill-wave mr-2"></i><span data-i18n="pos.cash">Nakit</span>
                <span class="text-xs opacity-75 ml-1">F1</span>
              </button>
              <button class="payment-btn p-4 rounded-lg bg-blue-500 text-white font-bold hover:bg-blue-600" data-pay="card">
                <i class="fas fa-credit-card mr-2"></i><span data-i18n="pos.card">Kredi Kartı</span>
                <span class="text-xs opacity-75 ml-1">F2</span>
              </button>
              <button class="payment-btn p-4 rounded-lg bg-purple-500 text-white font-bold hover:bg-purple-600" data-pay="split">
                <i class="fas fa-cash-register mr-2"></i><span data-i18n="pos.split">Parçalı</span>
              </button>
              <button class="payment-btn p-4 rounded-lg bg-gray-500 text-white font-bold hover:bg-gray-600" data-pay="qr">
                <i class="fas fa-qrcode mr-2"></i><span data-i18n="pos.qr">QR</span>
              </button>
            </div>

            <!-- Hızlı Aksiyonlar -->
            <div class="grid grid-cols-4 gap-2">
              <button id="holdBtn" class="p-3 rounded-lg bg-yellow-500 text-white hover:bg-yellow-600">
                <i class="fas fa-pause mr-2"></i><span data-i18n="pos.hold">Beklet</span>
                <span class="text-xs opacity-75 ml-1">F3</span>
              </button>
              <button id="cancelBtn" class="p-3 rounded-lg bg-red-500 text-white hover:bg-red-600">
                <i class="fas fa-times mr-2"></i><span data-i18n="pos.cancel">İptal</span>
              </button>
              <button id="printBtn" class="p-3 rounded-lg bg-[var(--primary)] text-white hover:bg-[var(--primary-dark)]">
                <i class="fas fa-print mr-2"></i><span data-i18n="pos.print">Yazdır</span>
              </button>
              <button id="discountBtn" class="p-3 rounded-lg bg-slate-700 text-white hover:bg-slate-800">
                <i class="fas fa-percent mr-2"></i><span data-i18n="pos.discountBtn">İndirim</span>
              </button>
            </div>

            <!-- Yazdırma: sadece Ödeme İşlemleri ekranında (modal) -->
            <div class="modal-only mt-3 w-full gap-2">
              <button id="printLastReceiptBtn" class="flex-1 touch-target p-3 rounded-lg bg-slate-800 text-white hover:bg-slate-900">
                <i class="fas fa-receipt mr-2"></i><span data-i18n="pos.printLast">Son Fişi Yazdır</span>
              </button>
              <button id="printScreenReceiptBtn" class="flex-1 touch-target p-3 rounded-lg bg-[var(--primary)] text-white hover:bg-[var(--primary-dark)]">
                <i class="fas fa-print mr-2"></i><span data-i18n="pos.printScreen">Ekrandaki Fişi Yazdır</span>
              </button>
            </div>
            </div>

            <!-- Compact payment opener (ALWAYS visible) -->
            <div id="paymentCompactBar" class="space-y-2">
              <div class="flex items-center justify-between text-lg font-bold">
                <span data-i18n="pos.totalLine">TOPLAM:</span>
                <span id="totalCompact">0.00 ₺</span>
              </div>
              <button id="paymentCompactBtn" class="touch-target w-full h-12 rounded-lg bg-[var(--primary)] text-white font-bold flex items-center justify-center gap-2">
                <i class="fas fa-credit-card"></i>
                <span data-i18n="pos.paymentActions">Ödeme İşlemleri</span>
              </button>
            </div>

          </div>
        </div>
      </main>
    </div>
  </div>

  <!-- Payment Modal (center, not full screen) -->
  <div id="paymentModal" class="fixed inset-0 hidden z-50 items-center justify-center p-4 bg-black/50">
    <div class="bg-[var(--surface)] rounded-lg shadow-xl w-full max-w-4xl max-h-[90vh] overflow-hidden flex flex-col">
      <div class="px-4 py-3 border-b border-[var(--border)] flex items-center justify-between">
        <div class="font-extrabold text-lg"><span data-i18n="pos.totalLine">TOPLAM:</span> <span id="paymentPageTotal">0.00 ₺</span></div>
        <button id="paymentModalClose" class="touch-target px-3 py-2 rounded-lg border border-[var(--border)] hover:bg-[var(--background)]">
          <i class="fas fa-times mr-2"></i><span data-i18n="pos.close">Kapat</span>
        </button>
      </div>
      <div id="paymentModalBody" class="flex-1 overflow-y-auto p-4">
        <!-- Payment content will be inserted here -->
      </div>
    </div>
  </div>

  <!-- Modal: Ürün Düzenle (aynı zamanda yeni ürün ekleme) -->
  <div id="productEditModal" class="fixed inset-0 bg-black bg-opacity-50 hidden items-center justify-center z-50 p-4">
    <div class="bg-[var(--surface)] rounded-lg shadow-xl w-full max-w-2xl max-h-[90vh] overflow-hidden flex flex-col">
      <div class="p-4 border-b border-[var(--border)] flex items-center justify-between">
        <h3 class="text-lg font-bold" id="productEditTitle">Yeni Ürün Ekle</h3>
        <button id="closeProductEditModal" class="p-2 rounded-lg hover:bg-[var(--background)]" aria-label="Close">
          <i class="fas fa-times"></i>
        </button>
      </div>
      <div class="flex-1 overflow-y-auto p-6">
        <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
          <div>
            <label class="block text-sm mb-2">Ürün Adı</label>
            <input id="editProductName" type="text" class="w-full px-4 py-2 rounded-lg border border-[var(--border)] bg-[var(--surface)]" placeholder="Ürün adı">
          </div>
          <div>
            <label class="block text-sm mb-2">Kategori</label>
            <select id="editProductCategory" class="w-full px-4 py-2 rounded-lg border border-[var(--border)] bg-[var(--surface)]">
              <option value="Yiyecekler">Yiyecekler</option>
              <option value="İçecekler">İçecekler</option>
              <option value="Tatlılar">Tatlılar</option>
              <option value="Kahvaltı">Kahvaltı</option>
              <option value="Aperatifler">Aperatifler</option>
              <option value="Özel Menü">Özel Menü</option>
              <option value="Kampanyalı">Kampanyalı</option>
            </select>
          </div>
          <div>
            <label class="block text-sm mb-2">Fiyat (₺)</label>
            <input id="editProductPrice" type="text" class="w-full px-4 py-2 rounded-lg border border-[var(--border)] bg-[var(--surface)]" placeholder="0,00">
          </div>
          <div>
            <label class="block text-sm mb-2">Stok</label>
            <input id="editProductStock" type="number" class="w-full px-4 py-2 rounded-lg border border-[var(--border)] bg-[var(--surface)]" value="0" min="0">
          </div>
          <div class="md:col-span-2">
            <label class="block text-sm mb-2">Barkod</label>
            <input id="editProductBarcode" type="text" class="w-full px-4 py-2 rounded-lg border border-[var(--border)] bg-[var(--surface)]" placeholder="Opsiyonel">
          </div>
          <div class="md:col-span-2">
            <label class="block text-sm mb-2">Kampanya</label>
            <input id="editProductCampaign" type="text" class="w-full px-4 py-2 rounded-lg border border-[var(--border)] bg-[var(--surface)]" placeholder="Örn: 2 Al 1 Öde">
          </div>
        </div>
      </div>
      <div class="p-4 border-t border-[var(--border)] flex justify-between">
        <button id="deleteProductBtn" class="px-6 py-2 rounded-lg bg-red-500 text-white hover:bg-red-600 hidden">
          <i class="fas fa-trash mr-2"></i><span>Sil</span>
        </button>
        <div class="flex gap-3">
          <button id="cancelProductEdit" class="px-6 py-2 rounded-lg border border-[var(--border)] hover:bg-[var(--background)]">
            <span data-i18n="pos.cancel">İptal</span>
          </button>
          <button id="saveProductEdit" class="px-6 py-2 rounded-lg bg-[var(--primary)] text-white hover:bg-[var(--primary-dark)]">
            <i class="fas fa-save mr-2"></i><span data-i18n="pos.save">Kaydet</span>
          </button>
        </div>
      </div>
    </div>
  </div>

  <!-- Modal: Satır Düzenle -->
  <div id="lineEditModal" class="fixed inset-0 bg-black bg-opacity-50 hidden items-center justify-center z-50 p-4">
    <div class="bg-[var(--surface)] rounded-lg shadow-xl w-full max-w-md">
      <div class="p-4 border-b border-[var(--border)] flex items-center justify-between">
        <h3 class="text-lg font-bold" id="lineEditTitle">Satır Düzenle</h3>
        <button id="lineEditClose" class="p-2 rounded-lg hover:bg-[var(--background)]" aria-label="Close">
          <i class="fas fa-xmark"></i>
        </button>
      </div>
      <div class="p-4 space-y-4">
        <div class="text-sm text-[var(--text-secondary)]" id="lineEditProductName">—</div>

        <div>
          <label class="block text-sm mb-2">Miktar</label>
          <input id="lineEditQty" type="text" readonly
                 class="w-full px-4 py-3 text-xl font-bold rounded-lg border border-[var(--border)] bg-[var(--background)] text-right cursor-pointer"
                 value="1">
          <p class="mt-1 text-xs text-[var(--text-secondary)]">Miktara çift tıkla → klavye açılır.</p>
        </div>

        <div>
          <label class="block text-sm mb-2">Satır İndirimi (%)</label>
          <input id="lineEditDisc" type="text" readonly
                 class="w-full px-4 py-3 text-xl font-bold rounded-lg border border-[var(--border)] bg-[var(--background)] text-right cursor-pointer"
                 value="0">
          <p class="mt-1 text-xs text-[var(--text-secondary)]">İndirim alanına çift tıkla → klavye açılır.</p>
        </div>

        <div class="flex gap-2">
          <button id="lineEditRemoveDisc" class="touch-target flex-1 h-12 rounded-lg border border-[var(--border)] bg-[var(--background)] hover:bg-[var(--surface)] font-semibold">İndirimi Sıfırla</button>
          <button id="lineEditSave" class="touch-target flex-1 h-12 rounded-lg bg-[var(--primary)] text-white hover:bg-[var(--primary-dark)] font-bold">Kaydet</button>
        </div>
      </div>
    </div>
  </div>

  <!-- Modal: Keypad -->
  <div id="numpadModal" class="fixed inset-0 bg-black bg-opacity-50 hidden items-center justify-center z-50">
    <div class="bg-[var(--surface)] rounded-lg shadow-xl w-96 max-w-full m-4">
      <div class="p-4 border-b border-[var(--border)] flex items-center justify-between">
        <h3 class="text-lg font-bold" id="numpadTitle">Miktar Gir</h3>
        <button id="numpadCloseX" class="p-2 rounded-lg hover:bg-[var(--background)]" aria-label="Close">
          <i class="fas fa-xmark"></i>
        </button>
      </div>
      <div class="p-4">
        <input type="text" id="numpadInput"
               class="w-full px-4 py-3 text-2xl font-bold rounded-lg border border-[var(--border)] bg-[var(--background)] text-right mb-4"
               value="0" readonly>

        <div class="grid grid-cols-3 gap-2">
          <button class="numpad-key touch-target p-4 text-xl rounded-lg border border-[var(--border)] bg-[var(--background)]">7</button>
          <button class="numpad-key touch-target p-4 text-xl rounded-lg border border-[var(--border)] bg-[var(--background)]">8</button>
          <button class="numpad-key touch-target p-4 text-xl rounded-lg border border-[var(--border)] bg-[var(--background)]">9</button>
          <button class="numpad-key touch-target p-4 text-xl rounded-lg border border-[var(--border)] bg-[var(--background)]">4</button>
          <button class="numpad-key touch-target p-4 text-xl rounded-lg border border-[var(--border)] bg-[var(--background)]">5</button>
          <button class="numpad-key touch-target p-4 text-xl rounded-lg border border-[var(--border)] bg-[var(--background)]">6</button>
          <button class="numpad-key touch-target p-4 text-xl rounded-lg border border-[var(--border)] bg-[var(--background)]">1</button>
          <button class="numpad-key touch-target p-4 text-xl rounded-lg border border-[var(--border)] bg-[var(--background)]">2</button>
          <button class="numpad-key touch-target p-4 text-xl rounded-lg border border-[var(--border)] bg-[var(--background)]">3</button>
          <button class="numpad-key touch-target p-4 text-xl rounded-lg border border-[var(--border)] bg-[var(--background)]">0</button>
          <button class="numpad-key touch-target p-4 text-xl rounded-lg border border-[var(--border)] bg-[var(--background)]">,</button>
          <button class="numpad-key touch-target p-4 text-xl rounded-lg border border-[var(--border)] bg-[var(--background)]" data-key="enter">
            <i class="fas fa-arrow-turn-down"></i>
          </button>
        </div>

        <div class="grid grid-cols-4 gap-2 mt-4">
          <button id="numpadClear" class="p-3 rounded-lg bg-gray-500 text-white hover:bg-gray-600" data-i18n="pos.numpad.clear">C</button>
          <button id="numpadBackspace" class="p-3 rounded-lg bg-gray-500 text-white hover:bg-gray-600" aria-label="Backspace">
            <i class="fas fa-backspace"></i>
          </button>
          <button id="numpadCancel" class="p-3 rounded-lg bg-red-500 text-white hover:bg-red-600" data-i18n="pos.numpad.cancel">İptal</button>
          <button id="numpadConfirm" class="p-3 rounded-lg bg-green-500 text-white hover:bg-green-600" data-i18n="pos.numpad.confirm">Onay</button>
        </div>
      </div>
    </div>
  </div>

  <!-- Modal: Customer Ekle -->
  <div id="customerModal" class="fixed inset-0 bg-black bg-opacity-50 hidden items-center justify-center z-50 p-4">
    <div class="bg-[var(--surface)] rounded-lg shadow-xl w-full max-w-2xl max-h-[90vh] overflow-hidden flex flex-col">
      <div class="p-4 border-b border-[var(--border)] flex items-center justify-between">
        <h3 class="text-lg font-bold" data-i18n="pos.customer.new">Yeni Cari Ekle</h3>
        <button id="closeCustomerModal" class="p-2 rounded-lg hover:bg-[var(--background)]" aria-label="Close">
          <i class="fas fa-times"></i>
        </button>
      </div>
      <div class="flex-1 overflow-y-auto p-6">
        <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
          <div>
            <label class="block text-sm mb-2" data-i18n="pos.customer.code">Cari No</label>
            <input id="customerCode" type="text" class="w-full px-4 py-2 rounded-lg border border-[var(--border)] bg-[var(--surface)]" readonly>
          </div>
          <div>
            <label class="block text-sm mb-2" data-i18n="pos.customer.company">Şirket Adı *</label>
            <input id="customerCompany" type="text" class="w-full px-4 py-2 rounded-lg border border-[var(--border)] bg-[var(--surface)]" required>
          </div>
          <div>
            <label class="block text-sm mb-2" data-i18n="pos.customer.taxNo">Vergi No</label>
            <input id="customerTaxNo" type="text" class="w-full px-4 py-2 rounded-lg border border-[var(--border)] bg-[var(--surface)]">
          </div>
          <div>
            <label class="block text-sm mb-2" data-i18n="pos.customer.taxOffice">Vergi Dairesi</label>
            <input id="customerTaxOffice" type="text" class="w-full px-4 py-2 rounded-lg border border-[var(--border)] bg-[var(--surface)]">
          </div>
          <div class="md:col-span-2">
            <label class="block text-sm mb-2" data-i18n="pos.customer.address">Adres</label>
            <textarea id="customerAddress" rows="2" class="w-full px-4 py-2 rounded-lg border border-[var(--border)] bg-[var(--surface)]"></textarea>
          </div>
          <div>
            <label class="block text-sm mb-2" data-i18n="pos.customer.country">Ülke</label>
            <select id="customerCountry" class="w-full px-4 py-2 rounded-lg border border-[var(--border)] bg-[var(--surface)]">
              <option value="Türkiye">Türkiye</option>
              <option value="Diğer">Diğer</option>
            </select>
          </div>
          <div>
            <label class="block text-sm mb-2" data-i18n="pos.customer.city">İl</label>
            <input id="customerCity" type="text" class="w-full px-4 py-2 rounded-lg border border-[var(--border)] bg-[var(--surface)]">
          </div>
          <div>
            <label class="block text-sm mb-2" data-i18n="pos.customer.district">İlçe</label>
            <input id="customerDistrict" type="text" class="w-full px-4 py-2 rounded-lg border border-[var(--border)] bg-[var(--surface)]">
          </div>
          <div class="md:col-span-2">
            <label class="block text-sm mb-2" data-i18n="pos.customer.discount">İndirim Oranı (%)</label>
            <input id="customerDiscount" type="number" min="0" max="100" step="1" class="w-full px-4 py-2 rounded-lg border border-[var(--border)] bg-[var(--surface)]" value="0">
          </div>
        </div>
      </div>
      <div class="p-4 border-t border-[var(--border)] flex justify-end gap-3">
        <button id="cancelCustomer" class="px-6 py-2 rounded-lg border border-[var(--border)] hover:bg-[var(--background)]" data-i18n="pos.cancel">İptal</button>
        <button id="saveCustomer" class="px-6 py-2 rounded-lg bg-[var(--primary)] text-white hover:bg-[var(--primary-dark)]" data-i18n="pos.save">Kaydet</button>
      </div>
    </div>
  </div>

  <!-- Modal: Discount -->
  <div id="discountModal" class="fixed inset-0 bg-black bg-opacity-50 hidden items-center justify-center z-50 p-4">
    <div class="bg-[var(--surface)] rounded-lg shadow-xl w-full max-w-md">
      <div class="p-4 border-b border-[var(--border)] flex items-center justify-between">
        <h3 class="text-lg font-bold" data-i18n="pos.discountTitle">İndirim Uygula</h3>
        <button id="closeDiscountModal" class="p-2 rounded-lg hover:bg-[var(--background)]" aria-label="Close">
          <i class="fas fa-times"></i>
        </button>
      </div>
      <div class="p-4 space-y-4">
        <div>
          <label class="block text-sm mb-2">İndirim Tipi</label>
          <div class="flex gap-2">
            <button id="discountPercent" class="discount-type flex-1 py-3 rounded-lg border border-[var(--border)] bg-[var(--background)] font-semibold">%</button>
            <button id="discountAmount" class="discount-type flex-1 py-3 rounded-lg border border-[var(--border)] bg-[var(--surface)] font-semibold">₺</button>
          </div>
        </div>
        <div>
          <label class="block text-sm mb-2" data-i18n="pos.discountValue">Değer</label>
          <input id="discountValue" type="text" readonly
                 class="w-full px-4 py-3 text-xl font-bold rounded-lg border border-[var(--border)] bg-[var(--background)] text-right cursor-pointer"
                 value="0">
          <p class="mt-1 text-xs text-[var(--text-secondary)]" data-i18n="pos.discountHint">Değer alanına tıkla → klavye açılır.</p>
        </div>
        <div id="discountPreview" class="rounded-lg border border-[var(--border)] bg-[var(--background)] p-3">
          <div class="text-sm font-semibold" data-i18n="pos.discountPreview">Önizleme</div>
          <div class="mt-1 text-lg font-bold" id="discountPreviewText">0.00 ₺</div>
        </div>
        <div class="flex gap-2">
          <button id="removeDiscount" class="touch-target flex-1 h-12 rounded-lg border border-[var(--border)] bg-[var(--background)] hover:bg-[var(--surface)] font-semibold" data-i18n="pos.remove">Kaldır</button>
          <button id="applyDiscount" class="touch-target flex-1 h-12 rounded-lg bg-[var(--primary)] text-white hover:bg-[var(--primary-dark)] font-bold" data-i18n="pos.apply">Uygula</button>
        </div>
      </div>
    </div>
  </div>

  <!-- Toast -->
  <div id="toast" class="fixed top-4 right-4 bg-green-500 text-white px-6 py-3 rounded-lg shadow-lg z-50 hidden">
    <i class="fas fa-check mr-2"></i><span id="toastMessage"></span>
  </div>

  <script>
    /* ===============================
       STATE
    ================================ */
    const state = {
      cart: JSON.parse(localStorage.getItem('pos_cart')) || [],
      products: [],
      customers: JSON.parse(localStorage.getItem('pos_customers')) || [
        { id: 1, code: 'FT-0001', name: 'Ali Yılmaz', taxNo: '1111111111', taxOffice: '', address: '', country: 'Türkiye', city: 'İstanbul', district: 'Kadıköy', discountRate: 10 },
        { id: 2, code: 'FT-0002', name: 'ABC Restaurant', taxNo: '2222222222', taxOffice: 'Beyoğlu', address: 'İstanbul', country: 'Türkiye', city: 'İstanbul', district: 'Beyoğlu', discountRate: 0 }
      ],
      currentCustomer: null,
      language: localStorage.getItem('pos_lang') || 'tr',
      theme: localStorage.getItem('pos_theme') || 'light',
      accent: localStorage.getItem('pos_accent') || 'blue',
      activeCategory: 'Tümü',
      searchQuery: '',
      reorderMode: localStorage.getItem('pos_reorder') === '1',
      discount: JSON.parse(localStorage.getItem('pos_discount')) || { type: null, value: 0 },
      keypad: { action: null, index: null },
      lineEdit: { index: null },
      productEdit: { id: null, isNew: false }
    };

    const defaultProducts = [
      { id: 1, name: "Pizza Margarita", price: 85.00, category: "Yiyecekler", stock: 10, campaign: "2 Al 1 Öde" },
      { id: 2, name: "Hamburger", price: 65.00, category: "Yiyecekler", stock: 15, campaign: null },
      { id: 3, name: "Kola", price: 18.00, category: "İçecekler", stock: 50, campaign: null, barcode: '8690000000003' },
      { id: 4, name: "Su", price: 8.00, category: "İçecekler", stock: 100, campaign: null, barcode: '8681158605471' },
      { id: 5, name: "Cheesecake", price: 45.00, category: "Tatlılar", stock: 8, campaign: null },
      { id: 6, name: "Kahve", price: 25.00, category: "İçecekler", stock: 30, campaign: null },
      { id: 7, name: "Tavuk Şiş", price: 75.00, category: "Yiyecekler", stock: 12, campaign: "İndirimli" },
      { id: 8, name: "Salata", price: 35.00, category: "Aperatifler", stock: 20, campaign: null },
      { id: 9, name: "Çay", price: 10.00, category: "Kahvaltı", stock: 60, campaign: null },
      { id: 10, name: "Baklava", price: 55.00, category: "Tatlılar", stock: 5, campaign: null },
      { id: 11, name: "Özel Menü 1", price: 120.00, category: "Özel Menü", stock: 4, campaign: null },
      { id: 12, name: "Kampanyalı Menü", price: 99.90, category: "Kampanyalı", stock: 7, campaign: "Kampanya" }
    ];

    function loadProducts() {
      const savedOrder = JSON.parse(localStorage.getItem('pos_products_order'));
      const savedProducts = JSON.parse(localStorage.getItem('pos_products'));

      const base = Array.isArray(savedProducts) && savedProducts.length ? savedProducts : defaultProducts;

      if (Array.isArray(savedOrder) && savedOrder.length) {
        const map = new Map(base.map(p => [p.id, p]));
        const ordered = [];
        savedOrder.forEach(id => { if (map.has(id)) ordered.push(map.get(id)); });
        base.forEach(p => { if (!savedOrder.includes(p.id)) ordered.push(p); });
        state.products = ordered;
      } else {
        state.products = base;
      }
    }

    /* ===============================
       i18n
    ================================ */
    const translations = {
      tr: {
        'pos.title': 'POS Hızlı Satış',
        'pos.fastSale': 'Hızlı Satış',
        'pos.heldReceipts': 'Bekletilen Fişler',
        'pos.dayEnd': 'Gün Sonu',
        'pos.customers': 'Cariler',
        'pos.settings': 'Ayarlar',
        'pos.printer': 'Yazıcı Bağlı',
        'pos.online': 'Çevrimiçi',
        'pos.profile': 'Profil',
        'pos.logout': 'Çıkış',
        'pos.accent': 'Renk',
        'pos.system': 'SİSTEM DURUMU',
        'pos.reorder': 'Ürünleri düzenle',
        'pos.reorderHint': 'Açıkken ürün kartlarını sürükleyip bırakabilirsiniz.',
        'pos.search': 'Ürün ara...',
        'pos.barcode': 'Barkod okut / yaz...',
        'pos.searchHint': 'Arama alanına çift tıklayın → sayısal klavye açılır.',
        'pos.customerSearch': 'Müşteri adı / Vergi No ara...',
        'pos.cart': 'SEPET',
        'pos.addProduct': 'Ürün Ekle',
        'pos.paymentActions': 'Ödeme İşlemleri',
        'pos.cart.empty': 'Sepet boş - ürün seçin',
        'pos.subtotal': 'Ara Toplam:',
        'pos.discount': 'İndirim:',
        'pos.taxLine': 'KDV (%18):',
        'pos.customerDiscount': 'Cari İndirimi:',
        'pos.lineDiscount': 'Satır İndirimi:',
        'pos.campaignDiscount': 'Kampanya İndirimi:',
        'pos.giftDiscount': 'Hediye:',
        'pos.printLast': 'Son Fişi Yazdır',
        'pos.printScreen': 'Ekrandaki Fişi Yazdır',
        'pos.totalLine': 'TOPLAM:',
        'pos.paymentAmount': 'Ödeme Tutarı',
        'pos.paymentHint': 'Tutar alanına tıkla → klavye açılır.',
        'pos.cash': 'Nakit',
        'pos.card': 'Kredi Kartı',
        'pos.split': 'Parçalı',
        'pos.qr': 'QR',
        'pos.hold': 'Beklet',
        'pos.cancel': 'İptal',
        'pos.print': 'Yazdır',
        'pos.discountBtn': 'İndirim',
        'pos.close': 'Kapat',
        'pos.numpad.quantity': 'Miktar Gir',
        'pos.numpad.payment': 'Ödeme Tutarı Gir',
        'pos.numpad.search': 'Barkod / Sayı Gir',
        'pos.numpad.clear': 'Temizle',
        'pos.numpad.cancel': 'İptal',
        'pos.numpad.confirm': 'Onay',
        'pos.customer.new': 'Yeni Cari Ekle',
        'pos.customer.code': 'Cari No',
        'pos.customer.company': 'Şirket Adı *',
        'pos.customer.taxNo': 'Vergi No',
        'pos.customer.taxOffice': 'Vergi Dairesi',
        'pos.customer.address': 'Adres',
        'pos.customer.country': 'Ülke',
        'pos.customer.city': 'İl',
        'pos.customer.district': 'İlçe',
        'pos.customer.discount': 'İndirim Oranı (%)',
        'pos.save': 'Kaydet',
        'pos.discountTitle': 'İndirim Uygula',
        'pos.discountValue': 'Değer',
        'pos.discountHint': 'Değer alanına tıkla → klavye açılır.',
        'pos.discountPreview': 'Önizleme',
        'pos.remove': 'Kaldır',
        'pos.apply': 'Uygula',
        'toast.added': 'Ürün sepete eklendi!',
        'toast.updated': 'Sepet güncellendi!',
        'toast.removed': 'Ürün sepetten çıkarıldı!',
        'toast.held': 'Fiş bekletildi!',
        'toast.discount': 'İndirim uygulandı!',
        'toast.customerAdded': 'Cari kaydedildi!',
        'toast.customerSelected': 'Cari seçildi!',
        'toast.productAdded': 'Ürün eklendi!',
        'toast.productEdited': 'Ürün güncellendi!',
        'toast.productDeleted': 'Ürün silindi!'
      },
      en: {
        'pos.title': 'POS Fast Sale',
        'pos.fastSale': 'Fast Sale',
        'pos.heldReceipts': 'Held Receipts',
        'pos.dayEnd': 'End of Day',
        'pos.customers': 'Customers',
        'pos.settings': 'Settings',
        'pos.printer': 'Printer Connected',
        'pos.online': 'Online',
        'pos.profile': 'Profile',
        'pos.logout': 'Logout',
        'pos.accent': 'Color',
        'pos.system': 'SYSTEM',
        'pos.reorder': 'Reorder products',
        'pos.reorderHint': 'Drag & drop product cards while enabled.',
        'pos.search': 'Search product...',
        'pos.barcode': 'Scan / type barcode...',
        'pos.searchHint': 'Double click search → numeric keypad opens.',
        'pos.customerSearch': 'Search by name / tax no...',
        'pos.cart': 'CART',
        'pos.addProduct': 'Add Product',
        'pos.paymentActions': 'Payment Actions',
        'pos.cart.empty': 'Cart is empty - select products',
        'pos.subtotal': 'Subtotal:',
        'pos.discount': 'Discount:',
        'pos.taxLine': 'Tax (18%):',
        'pos.customerDiscount': 'Customer Discount:',
        'pos.lineDiscount': 'Line Discount:',
        'pos.campaignDiscount': 'Campaign Discount:',
        'pos.giftDiscount': 'Gift:',
        'pos.printLast': 'Print Last Receipt',
        'pos.printScreen': 'Print On-Screen Receipt',
        'pos.totalLine': 'TOTAL:',
        'pos.paymentAmount': 'Payment Amount',
        'pos.paymentHint': 'Click amount → keypad opens.',
        'pos.cash': 'Cash',
        'pos.card': 'Card',
        'pos.split': 'Split',
        'pos.qr': 'QR',
        'pos.hold': 'Hold',
        'pos.cancel': 'Cancel',
        'pos.print': 'Print',
        'pos.discountBtn': 'Discount',
        'pos.close': 'Close',
        'pos.numpad.quantity': 'Enter Quantity',
        'pos.numpad.payment': 'Enter Payment Amount',
        'pos.numpad.search': 'Enter Barcode / Number',
        'pos.numpad.clear': 'Clear',
        'pos.numpad.cancel': 'Cancel',
        'pos.numpad.confirm': 'Confirm',
        'pos.customer.new': 'Add Customer',
        'pos.customer.code': 'Customer No',
        'pos.customer.company': 'Company Name *',
        'pos.customer.taxNo': 'Tax No',
        'pos.customer.taxOffice': 'Tax Office',
        'pos.customer.address': 'Address',
        'pos.customer.country': 'Country',
        'pos.customer.city': 'City',
        'pos.customer.district': 'District',
        'pos.customer.discount': 'Discount Rate (%)',
        'pos.save': 'Save',
        'pos.discountTitle': 'Apply Discount',
        'pos.discountValue': 'Value',
        'pos.discountHint': 'Click value → keypad opens.',
        'pos.discountPreview': 'Preview',
        'pos.remove': 'Remove',
        'pos.apply': 'Apply',
        'toast.added': 'Product added to cart!',
        'toast.updated': 'Cart updated!',
        'toast.removed': 'Product removed!',
        'toast.held': 'Receipt held!',
        'toast.discount': 'Discount applied!',
        'toast.customerAdded': 'Customer saved!',
        'toast.customerSelected': 'Customer selected!',
        'toast.productAdded': 'Product added!',
        'toast.productEdited': 'Product updated!',
        'toast.productDeleted': 'Product deleted!'
      }
    };

    function t(key) {
      return (translations[state.language] && translations[state.language][key]) || key;
    }

    function applyLanguage() {
      document.documentElement.lang = state.language;
      localStorage.setItem('pos_lang', state.language);

      document.querySelectorAll('[data-i18n]').forEach(el => {
        const key = el.getAttribute('data-i18n');
        el.textContent = t(key);
      });

      document.querySelectorAll('[data-i18n-placeholder]').forEach(el => {
        const key = el.getAttribute('data-i18n-placeholder');
        el.setAttribute('placeholder', t(key));
      });

      document.getElementById('langTR').classList.toggle('bg-[var(--surface)]', state.language === 'tr');
      document.getElementById('langEN').classList.toggle('bg-[var(--surface)]', state.language === 'en');
      document.getElementById('langTR').classList.toggle('bg-[var(--background)]', state.language !== 'tr');
      document.getElementById('langEN').classList.toggle('bg-[var(--background)]', state.language !== 'en');

      renderCategoryTabs();
      renderProducts();
      renderCart();
    }

    /* ===============================
       THEME / ACCENT
    ================================ */
    function applyTheme() {
      document.documentElement.setAttribute('data-theme', state.theme);
      document.documentElement.setAttribute('data-accent', state.accent);
      localStorage.setItem('pos_theme', state.theme);
      localStorage.setItem('pos_accent', state.accent);

      document.querySelectorAll('.theme-btn').forEach(btn => {
        const isActive = btn.dataset.theme === state.theme;
        btn.classList.toggle('ring-2', isActive);
        btn.classList.toggle('ring-[var(--primary)]', isActive);
      });

      document.getElementById('accentDropdownBtn').querySelector('div').style.backgroundColor = `var(--primary)`;
    }

    /* ===============================
       HELPERS
    ================================ */
    function formatMoneyTR(num) {
      const fixed = Number(num || 0).toFixed(2);
      return fixed.replace('.', ',') + ' ₺';
    }

    function parseTRNumber(str) {
      if (typeof str !== 'string') return Number(str || 0);
      const cleaned = str.replace(/[^0-9,]/g, '').replace(',', '.');
      const n = parseFloat(cleaned);
      return Number.isFinite(n) ? n : 0;
    }

    function saveCustomers() {
      localStorage.setItem('pos_customers', JSON.stringify(state.customers));
    }

    function setReorderUI(on) {
      const toggle = document.getElementById('reorderToggle');
      const knob = document.getElementById('reorderKnob');
      toggle.checked = on;
      if (on) {
        toggle.parentElement.querySelector('span').classList.add('bg-[var(--primary)]');
        toggle.parentElement.querySelector('span').classList.remove('bg-gray-300');
        knob.classList.add('translate-x-4');
      } else {
        toggle.parentElement.querySelector('span').classList.remove('bg-[var(--primary)]');
        toggle.parentElement.querySelector('span').classList.add('bg-gray-300');
        knob.classList.remove('translate-x-4');
      }
      localStorage.setItem('pos_reorder', on ? '1' : '0');
    }

    function generateCustomerCode() {
      const maxCode = state.customers.reduce((max, c) => {
        const num = parseInt(c.code?.replace('FT-', '') || '0');
        return num > max ? num : max;
      }, 0);
      return `FT-${String(maxCode + 1).padStart(4, '0')}`;
    }

    /* ===============================
       CATEGORY TABS
    ================================ */
    const categories = ['Tümü','Yiyecekler','İçecekler','Tatlılar','Kahvaltı','Aperatifler','Özel Menü','Kampanyalı'];

    function renderCategoryTabs() {
      const wrap = document.getElementById('categoryTabs');
      wrap.innerHTML = '';
      categories.forEach(cat => {
        const btn = document.createElement('button');
        btn.className = 'category-tab px-4 py-2 rounded-lg border border-[var(--border)] bg-[var(--surface)] whitespace-nowrap';
        if (cat === state.activeCategory) {
          btn.classList.add('bg-[var(--primary)]','text-white');
          btn.classList.remove('bg-[var(--surface)]');
        }
        btn.textContent = cat;
        btn.addEventListener('click', () => {
          state.activeCategory = cat;
          renderCategoryTabs();
          renderProducts();
        });
        wrap.appendChild(btn);
      });
    }

    /* ===============================
       PRODUCTS
    ================================ */
    function getFilteredProducts() {
      const q = (state.searchQuery || '').trim().toLowerCase();
      return state.products.filter(p => {
        const catOk = state.activeCategory === 'Tümü' || p.category === state.activeCategory;
        const qOk = !q || p.name.toLowerCase().includes(q) || String(p.id).includes(q) || String(p.barcode||'').includes(q);
        return catOk && qOk;
      });
    }

    function renderProducts() {
      const grid = document.getElementById('productGrid');
      grid.innerHTML = '';

      const list = getFilteredProducts();
      list.forEach(product => {
        const card = document.createElement('div');
        card.className = `product-card relative bg-[var(--surface)] border border-[var(--border)] rounded-lg p-4 flex flex-col cursor-pointer ${product.stock === 0 ? 'opacity-50' : ''}`;

        card.setAttribute('draggable', state.reorderMode ? 'true' : 'false');
        card.dataset.pid = String(product.id);

        card.innerHTML = `
          ${product.campaign ? `<span class="absolute top-2 right-2 px-2 py-1 text-xs bg-[var(--primary)] text-white rounded">${product.campaign}</span>` : ''}
          ${state.reorderMode ? `<div class="absolute top-2 left-2 text-xs px-2 py-1 rounded bg-[var(--background)] border border-[var(--border)]"><i class="fas fa-grip-vertical mr-1"></i>${t('pos.reorder')}</div>` : ''}
          <div class="h-24 mb-3 bg-gray-100 rounded-lg flex items-center justify-center">
            <i class="fas fa-utensils text-3xl text-gray-400"></i>
          </div>
          <h3 class="font-bold mb-1 truncate">${product.name}</h3>
          <div class="text-xs text-[var(--text-secondary)]">${product.category}</div>
          <div class="flex justify-between items-center mt-2">
            <span class="text-lg font-bold text-[var(--primary)]">${formatMoneyTR(product.price).replace(' ₺','')} ₺</span>
            <span class="text-sm ${product.stock > 5 ? 'text-green-500' : 'text-yellow-500'}"><i class="fas fa-box mr-1"></i>${product.stock}</span>
          </div>
        `;

        // Normal modda tıklama: sepete ekle veya düzenle
        card.addEventListener('click', (e) => {
          if (state.reorderMode) {
            // Reorder modda ürüne tıklayınca düzenleme modunu aç
            openProductEditModal(product, false);
            return;
          }
          
          if (product.stock > 0) {
            addToCart(product);
          }
        });

        // Drag & drop reorder
        card.addEventListener('dragstart', (e) => {
          if (!state.reorderMode) return;
          e.dataTransfer.setData('text/plain', card.dataset.pid);
          e.dataTransfer.effectAllowed = 'move';
          card.classList.add('opacity-60');
        });
        card.addEventListener('dragend', () => card.classList.remove('opacity-60'));
        card.addEventListener('dragover', (e) => {
          if (!state.reorderMode) return;
          e.preventDefault();
          e.dataTransfer.dropEffect = 'move';
          card.classList.add('ring-2','ring-[var(--primary)]');
        });
        card.addEventListener('dragleave', () => card.classList.remove('ring-2','ring-[var(--primary)]'));
        card.addEventListener('drop', (e) => {
          if (!state.reorderMode) return;
          e.preventDefault();
          card.classList.remove('ring-2','ring-[var(--primary)]');
          const fromId = parseInt(e.dataTransfer.getData('text/plain'), 10);
          const toId = parseInt(card.dataset.pid, 10);
          if (!fromId || !toId || fromId === toId) return;
          reorderProducts(fromId, toId);
        });

        grid.appendChild(card);
      });

      if (list.length === 0) {
        grid.innerHTML = `
          <div class="col-span-full text-center py-10 text-[var(--text-secondary)]">
            <i class="fas fa-magnifying-glass text-3xl mb-3"></i>
            <div>${state.language === 'tr' ? 'Sonuç bulunamadı' : 'No results'}</div>
          </div>
        `;
      }
    }

    function reorderProducts(fromId, toId) {
      const arr = state.products.slice();
      const fromIndex = arr.findIndex(p => p.id === fromId);
      const toIndex = arr.findIndex(p => p.id === toId);
      if (fromIndex < 0 || toIndex < 0) return;
      const [moved] = arr.splice(fromIndex, 1);
      arr.splice(toIndex, 0, moved);
      state.products = arr;
      localStorage.setItem('pos_products_order', JSON.stringify(arr.map(p => p.id)));
      renderProducts();
      showToast(state.language === 'tr' ? 'Ürün sırası güncellendi!' : 'Order updated!');
    }

    /* ===============================
       PRODUCT EDIT MODAL
    ================================ */
    function openProductEditModal(product = null, isNew = true) {
      state.productEdit.id = product ? product.id : null;
      state.productEdit.isNew = isNew;
      
      const title = document.getElementById('productEditTitle');
      const deleteBtn = document.getElementById('deleteProductBtn');
      
      if (isNew) {
        title.textContent = t('pos.addProduct');
        deleteBtn.classList.add('hidden');
        
        // Reset form for new product
        document.getElementById('editProductName').value = '';
        document.getElementById('editProductCategory').value = 'Yiyecekler';
        document.getElementById('editProductPrice').value = '0,00';
        document.getElementById('editProductStock').value = '0';
        document.getElementById('editProductBarcode').value = '';
        document.getElementById('editProductCampaign').value = '';
      } else {
        title.textContent = product.name + ' Düzenle';
        deleteBtn.classList.remove('hidden');
        
        document.getElementById('editProductName').value = product.name;
        document.getElementById('editProductCategory').value = product.category;
        document.getElementById('editProductPrice').value = product.price.toFixed(2).replace('.', ',');
        document.getElementById('editProductStock').value = product.stock;
        document.getElementById('editProductBarcode').value = product.barcode || '';
        document.getElementById('editProductCampaign').value = product.campaign || '';
      }
      
      const modal = document.getElementById('productEditModal');
      modal.classList.remove('hidden');
      modal.classList.add('flex');
    }

    function closeProductEditModal() {
      const modal = document.getElementById('productEditModal');
      modal.classList.add('hidden');
      modal.classList.remove('flex');
      state.productEdit.id = null;
      state.productEdit.isNew = false;
    }

    function saveProductEdit() {
      const isNew = state.productEdit.isNew;
      
      const name = document.getElementById('editProductName').value.trim();
      if (!name) {
        alert(state.language === 'tr' ? 'Ürün adı gereklidir!' : 'Product name is required!');
        return;
      }
      
      const newProduct = {
        id: isNew ? (Math.max(...state.products.map(p => p.id), 0) + 1) : state.productEdit.id,
        name: name,
        category: document.getElementById('editProductCategory').value,
        price: parseTRNumber(document.getElementById('editProductPrice').value),
        stock: parseInt(document.getElementById('editProductStock').value) || 0,
        barcode: document.getElementById('editProductBarcode').value.trim() || null,
        campaign: document.getElementById('editProductCampaign').value.trim() || null
      };
      
      if (isNew) {
        // Yeni ürün ekle
        state.products.push(newProduct);
        showToast(t('toast.productAdded'));
      } else {
        // Mevcut ürünü güncelle
        const index = state.products.findIndex(p => p.id === state.productEdit.id);
        if (index !== -1) {
          state.products[index] = newProduct;
          showToast(t('toast.productEdited'));
        }
      }
      
      localStorage.setItem('pos_products', JSON.stringify(state.products));
      renderProducts();
      closeProductEditModal();
    }

    function deleteProduct() {
      const id = state.productEdit.id;
      if (!id) return;
      
      if (confirm(state.language === 'tr' ? 'Bu ürünü silmek istediğinize emin misiniz?' : 'Delete this product?')) {
        state.products = state.products.filter(p => p.id !== id);
        localStorage.setItem('pos_products', JSON.stringify(state.products));
        renderProducts();
        closeProductEditModal();
        showToast(t('toast.productDeleted'));
      }
    }

    /* ===============================
       CART
    ================================ */
    function saveCart() {
      localStorage.setItem('pos_cart', JSON.stringify(state.cart));
    }

    function addToCart(product) {
      const existingIndex = state.cart.findIndex(item => item.id === product.id);
      if (existingIndex > -1) state.cart[existingIndex].quantity += 1;
      else state.cart.push({ id: product.id, name: product.name, price: product.price, quantity: 1, lineDiscountPct: 0 });

      saveCart();
      renderCart();
      showToast(t('toast.added'));
    }

    function updateQuantity(index, delta) {
      if (!state.cart[index]) return;
      state.cart[index].quantity += delta;
      if (state.cart[index].quantity <= 0) {
        if (confirm(state.language === 'tr' ? 'Bu ürünü silmek istediğinize emin misiniz?' : 'Remove item?')) {
          state.cart.splice(index, 1);
        } else {
          state.cart[index].quantity = 1;
        }
      }
      saveCart();
      renderCart();
      showToast(t('toast.updated'));
    }

    function removeFromCart(index) {
      state.cart.splice(index, 1);
      saveCart();
      renderCart();
      showToast(t('toast.removed'));
    }

    function getCartTotals() {
      let subtotal = 0;
      let lineDiscount = 0;

      state.cart.forEach(item => {
        const line = (item.price * item.quantity);
        subtotal += line;
        const pct = Number(item.lineDiscountPct || 0);
        if (pct > 0) lineDiscount += line * (pct / 100);
      });

      let customerDiscount = 0;
      if (state.currentCustomer && Number(state.currentCustomer.discountRate) > 0) {
        customerDiscount = subtotal * (Number(state.currentCustomer.discountRate) / 100);
      }

      let campaignDiscount = 0;
      if (state.discount.type && Number(state.discount.value) > 0) {
        if (state.discount.type === 'percent') campaignDiscount = subtotal * (Number(state.discount.value) / 100);
        if (state.discount.type === 'amount') campaignDiscount = Number(state.discount.value);
      }

      const giftDiscount = 0;
      const discountTotal = Math.min(subtotal, customerDiscount + lineDiscount + campaignDiscount + giftDiscount);
      const taxableBase = Math.max(0, subtotal - discountTotal);
      const tax = taxableBase * 0.18;
      const total = taxableBase + tax;

      return { subtotal, customerDiscount, lineDiscount, campaignDiscount, giftDiscount, discountTotal, tax, total };
    }

    function renderCart() {
      const cartItems = document.getElementById('cartItems');
      const itemCount = document.getElementById('itemCount');
      const subtotalEl = document.getElementById('subtotal');
      const taxEl = document.getElementById('tax');
      const totalEl = document.getElementById('total');
      const discountRow = document.getElementById('discountRow');
      const discountEl = document.getElementById('discount');

      if (state.cart.length === 0) {
        cartItems.innerHTML = `
          <div class="text-center py-12 text-[var(--text-secondary)]">
            <i class="fas fa-shopping-cart text-4xl mb-4"></i>
            <p data-i18n="pos.cart.empty">${t('pos.cart.empty')}</p>
          </div>
        `;
        itemCount.textContent = state.language === 'tr' ? '0 ürün' : '0 item';

        subtotalEl.textContent = formatMoneyTR(0);
        taxEl.textContent = formatMoneyTR(0);
        totalEl.textContent = formatMoneyTR(0);

        const totalCompactEl = document.getElementById('totalCompact');
        if (totalCompactEl) totalCompactEl.textContent = formatMoneyTR(0);

        const cd = document.getElementById('customerDiscountAmount');
        const ld = document.getElementById('lineDiscountAmount');
        const camp = document.getElementById('campaignDiscountAmount');
        const gift = document.getElementById('giftDiscountAmount');
        if (cd) cd.textContent = formatMoneyTR(0);
        if (ld) ld.textContent = formatMoneyTR(0);
        if (camp) camp.textContent = formatMoneyTR(0);
        if (gift) gift.textContent = formatMoneyTR(0);

        discountRow.classList.add('hidden');
        document.getElementById('paymentAmount').value = '0,00';
        return;
      }

      let html = '';
      state.cart.forEach((item, index) => {
        const itemTotal = item.price * item.quantity;
        html += `
          <div class="cart-item p-3 rounded-lg border border-[var(--border)] bg-[var(--surface)]">
            <div class="flex justify-between items-start mb-2">
              <div class="flex-1">
                <h4 class="font-bold truncate">${item.name}</h4>
                <p class="text-sm text-[var(--text-secondary)]">${formatMoneyTR(item.price)}</p>
              </div>
              <div class="flex items-center gap-1">
                <button class="edit-item p-2 text-[var(--text-secondary)] hover:bg-[var(--background)] rounded" data-index="${index}" aria-label="Edit">
                  <i class="fas fa-pen"></i>
                </button>
                <button class="remove-item p-2 text-red-500 hover:bg-red-50 rounded" data-index="${index}" aria-label="Remove">
                  <i class="fas fa-trash"></i>
                </button>
              </div>
            </div>
            <div class="flex items-center justify-between">
              <div class="flex items-center space-x-2">
                <button class="decrement touch-target w-8 h-8 rounded-full border border-[var(--border)] flex items-center justify-center" data-index="${index}">
                  <i class="fas fa-minus text-xs"></i>
                </button>
                <span class="quantity-display px-3 py-1 border border-[var(--border)] rounded min-w-[60px] text-center cursor-pointer" data-index="${index}" title="Double click">
                  ${item.quantity}
                </span>
                <button class="increment touch-target w-8 h-8 rounded-full border border-[var(--border)] flex items-center justify-center" data-index="${index}">
                  <i class="fas fa-plus text-xs"></i>
                </button>
              </div>
              <span class="font-bold">${formatMoneyTR(itemTotal)}</span>
            </div>
          </div>
        `;
      });

      cartItems.innerHTML = html;
      itemCount.textContent = (state.language === 'tr' ? `${state.cart.length} ürün` : `${state.cart.length} item`);

      const { subtotal, customerDiscount, lineDiscount, campaignDiscount, giftDiscount, discountTotal, tax, total } = getCartTotals();
      subtotalEl.textContent = formatMoneyTR(subtotal);
      taxEl.textContent = formatMoneyTR(tax);
      totalEl.textContent = formatMoneyTR(total);

      const totalCompactEl = document.getElementById('totalCompact');
      if (totalCompactEl) totalCompactEl.textContent = formatMoneyTR(total);

      const cd = document.getElementById('customerDiscountAmount');
      const ld = document.getElementById('lineDiscountAmount');
      const camp = document.getElementById('campaignDiscountAmount');
      const gift = document.getElementById('giftDiscountAmount');
      if (cd) cd.textContent = formatMoneyTR(-customerDiscount);
      if (ld) ld.textContent = formatMoneyTR(-lineDiscount);
      if (camp) camp.textContent = formatMoneyTR(-campaignDiscount);
      if (gift) gift.textContent = formatMoneyTR(-giftDiscount);

      if (discountTotal > 0) {
        discountRow.classList.remove('hidden');
        discountRow.classList.add('flex');
        discountEl.textContent = formatMoneyTR(-discountTotal);
      } else {
        discountRow.classList.add('hidden');
      }

      document.getElementById('paymentAmount').value = Number(total).toFixed(2).replace('.', ',');

      // listeners
      document.querySelectorAll('.decrement').forEach(btn => {
        btn.addEventListener('click', (e) => updateQuantity(parseInt(e.currentTarget.dataset.index, 10), -1));
      });
      document.querySelectorAll('.increment').forEach(btn => {
        btn.addEventListener('click', (e) => updateQuantity(parseInt(e.currentTarget.dataset.index, 10), +1));
      });
      document.querySelectorAll('.edit-item').forEach(btn => {
        btn.addEventListener('click', (e) => {
          const index = parseInt(e.currentTarget.dataset.index, 10);
          openLineEdit(index);
        });
      });

      document.querySelectorAll('.remove-item').forEach(btn => {
        btn.addEventListener('click', (e) => {
          const index = parseInt(e.currentTarget.dataset.index, 10);
          if (confirm(state.language === 'tr' ? 'Bu ürünü silmek istediğinize emin misiniz?' : 'Remove item?')) removeFromCart(index);
        });
      });
      document.querySelectorAll('.quantity-display').forEach(display => {
        display.addEventListener('dblclick', (e) => openKeypad('quantity', parseInt(e.currentTarget.dataset.index, 10)));
      });
    }

    /* ===============================
       LINE EDIT
    ================================ */
    function openLineEdit(index) {
      if (!state.cart[index]) return;
      state.lineEdit.index = index;
      const item = state.cart[index];
      document.getElementById('lineEditProductName').textContent = item.name;
      document.getElementById('lineEditQty').value = String(item.quantity || 1);
      document.getElementById('lineEditDisc').value = String(item.lineDiscountPct || 0);
      const modal = document.getElementById('lineEditModal');
      modal.classList.remove('hidden');
      modal.classList.add('flex');
    }

    function closeLineEdit() {
      const modal = document.getElementById('lineEditModal');
      modal.classList.add('hidden');
      modal.classList.remove('flex');
      state.lineEdit.index = null;
    }

    function saveLineEdit() {
      const i = state.lineEdit.index;
      if (i === null || !state.cart[i]) return;
      const qty = Math.max(1, Math.floor(parseTRNumber(document.getElementById('lineEditQty').value || '1')));
      const disc = Math.max(0, Math.min(100, parseTRNumber(document.getElementById('lineEditDisc').value || '0')));
      state.cart[i].quantity = qty;
      state.cart[i].lineDiscountPct = disc;
      saveCart();
      renderCart();
      closeLineEdit();
      showToast(state.language === 'tr' ? 'Satır güncellendi' : 'Line updated');
    }

    /* ===============================
       CUSTOMER FUNCTIONS
    ================================ */
    function renderCustomerDropdown(filter = '') {
      const dropdown = document.getElementById('customerDropdown');
      if (!dropdown) return;

      const filtered = state.customers.filter(c =>
        c.name.toLowerCase().includes(filter.toLowerCase()) ||
        (c.taxNo && c.taxNo.includes(filter))
      );

      if (filtered.length === 0) {
        dropdown.innerHTML = `
          <div class="p-3 text-center text-[var(--text-secondary)]">
            ${state.language === 'tr' ? 'Sonuç bulunamadı' : 'No results'}
          </div>
        `;
        dropdown.classList.remove('hidden');
        return;
      }

      let html = '';
      filtered.forEach(customer => {
        html += `
          <button class="customer-option w-full text-left px-4 py-3 hover:bg-[var(--background)] border-b border-[var(--border)] last:border-b-0 flex justify-between items-center" data-id="${customer.id}">
            <div>
              <div class="font-semibold">${customer.name}</div>
              <div class="text-xs text-[var(--text-secondary)]">${customer.taxNo || ''} ${customer.discountRate > 0 ? `(%${customer.discountRate} indirim)` : ''}</div>
            </div>
            <div class="text-xs bg-[var(--primary)] text-white px-2 py-1 rounded">${customer.code}</div>
          </button>
        `;
      });

      dropdown.innerHTML = html;
      dropdown.classList.remove('hidden');

      // Add event listeners to customer options
      document.querySelectorAll('.customer-option').forEach(option => {
        option.addEventListener('click', (e) => {
          const id = parseInt(e.currentTarget.dataset.id);
          selectCustomer(id);
        });
      });
    }

    function selectCustomer(id) {
      const customer = state.customers.find(c => c.id === id);
      if (!customer) return;

      state.currentCustomer = customer;
      
      // Update UI
      document.getElementById('currentCustomerName').textContent = customer.name;
      document.getElementById('currentCustomerMeta').textContent = `(${customer.code})`;
      document.getElementById('currentCustomerBadge').classList.remove('hidden');
      
      // Close dropdown
      document.getElementById('customerDropdown').classList.add('hidden');
      document.getElementById('customerSearch').value = '';
      
      // Update cart totals
      renderCart();
      
      showToast(t('toast.customerSelected'));
    }

    function clearCurrentCustomer() {
      state.currentCustomer = null;
      document.getElementById('currentCustomerBadge').classList.add('hidden');
      document.getElementById('customerSearch').value = '';
      renderCart();
    }

    function openCustomerModal() {
      const modal = document.getElementById('customerModal');
      const codeField = document.getElementById('customerCode');
      
      // Generate new customer code
      codeField.value = generateCustomerCode();
      
      // Reset form
      document.getElementById('customerCompany').value = '';
      document.getElementById('customerTaxNo').value = '';
      document.getElementById('customerTaxOffice').value = '';
      document.getElementById('customerAddress').value = '';
      document.getElementById('customerCountry').value = 'Türkiye';
      document.getElementById('customerCity').value = '';
      document.getElementById('customerDistrict').value = '';
      document.getElementById('customerDiscount').value = '0';
      
      modal.classList.remove('hidden');
      modal.classList.add('flex');
    }

    function closeCustomerModal() {
      const modal = document.getElementById('customerModal');
      modal.classList.add('hidden');
      modal.classList.remove('flex');
    }

    function saveCustomer() {
      const company = document.getElementById('customerCompany').value.trim();
      if (!company) {
        alert(state.language === 'tr' ? 'Şirket adı gereklidir!' : 'Company name is required!');
        return;
      }

      const newCustomer = {
        id: Math.max(...state.customers.map(c => c.id), 0) + 1,
        code: document.getElementById('customerCode').value,
        name: company,
        taxNo: document.getElementById('customerTaxNo').value.trim() || null,
        taxOffice: document.getElementById('customerTaxOffice').value.trim() || '',
        address: document.getElementById('customerAddress').value.trim() || '',
        country: document.getElementById('customerCountry').value,
        city: document.getElementById('customerCity').value.trim() || '',
        district: document.getElementById('customerDistrict').value.trim() || '',
        discountRate: parseInt(document.getElementById('customerDiscount').value) || 0
      };

      state.customers.push(newCustomer);
      saveCustomers();
      closeCustomerModal();
      showToast(t('toast.customerAdded'));
      
      // Otomatik seç
      selectCustomer(newCustomer.id);
    }

    /* ===============================
       DISCOUNT FUNCTIONS
    ================================ */
    function openDiscountModal() {
      const modal = document.getElementById('discountModal');
      const preview = document.getElementById('discountPreviewText');
      
      // Set current discount values
      const percentBtn = document.getElementById('discountPercent');
      const amountBtn = document.getElementById('discountAmount');
      const valueField = document.getElementById('discountValue');
      
      if (state.discount.type === 'percent') {
        percentBtn.classList.add('bg-[var(--primary)]', 'text-white');
        percentBtn.classList.remove('bg-[var(--surface)]');
        amountBtn.classList.remove('bg-[var(--primary)]', 'text-white');
        amountBtn.classList.add('bg-[var(--surface)]');
      } else if (state.discount.type === 'amount') {
        amountBtn.classList.add('bg-[var(--primary)]', 'text-white');
        amountBtn.classList.remove('bg-[var(--surface)]');
        percentBtn.classList.remove('bg-[var(--primary)]', 'text-white');
        percentBtn.classList.add('bg-[var(--surface)]');
      } else {
        percentBtn.classList.remove('bg-[var(--primary)]', 'text-white');
        percentBtn.classList.add('bg-[var(--surface)]');
        amountBtn.classList.remove('bg-[var(--primary)]', 'text-white');
        amountBtn.classList.add('bg-[var(--surface)]');
      }
      
      valueField.value = state.discount.value || '0';
      updateDiscountPreview();
      
      modal.classList.remove('hidden');
      modal.classList.add('flex');
    }

    function closeDiscountModal() {
      const modal = document.getElementById('discountModal');
      modal.classList.add('hidden');
      modal.classList.remove('flex');
    }

    function updateDiscountPreview() {
      const value = parseTRNumber(document.getElementById('discountValue').value || '0');
      const type = state.discount.type;
      const preview = document.getElementById('discountPreviewText');
      
      if (type === 'percent') {
        preview.textContent = `%${value} indirim`;
      } else if (type === 'amount') {
        preview.textContent = `${formatMoneyTR(value)} indirim`;
      } else {
        preview.textContent = '0.00 ₺';
      }
    }

    function applyDiscount() {
      const value = parseTRNumber(document.getElementById('discountValue').value || '0');
      
      if (value <= 0) {
        state.discount = { type: null, value: 0 };
      } else {
        state.discount = { type: state.discount.type, value: value };
      }
      
      localStorage.setItem('pos_discount', JSON.stringify(state.discount));
      renderCart();
      closeDiscountModal();
      showToast(t('toast.discount'));
    }

    function removeDiscount() {
      state.discount = { type: null, value: 0 };
      localStorage.setItem('pos_discount', JSON.stringify(state.discount));
      renderCart();
      closeDiscountModal();
      showToast(state.language === 'tr' ? 'İndirim kaldırıldı' : 'Discount removed');
    }

    /* ===============================
       KEYPAD
    ================================ */
    function openKeypad(action, index = null) {
      state.keypad.action = action;
      state.keypad.index = index;

      const modal = document.getElementById('numpadModal');
      const title = document.getElementById('numpadTitle');
      const input = document.getElementById('numpadInput');

      if (action === 'quantity') {
        title.textContent = t('pos.numpad.quantity');
        input.value = String(state.cart[index]?.quantity || 1);
      }
      if (action === 'payment') {
        title.textContent = t('pos.numpad.payment');
        input.value = String(document.getElementById('paymentAmount').value || '0,00');
      }
      if (action === 'search') {
        title.textContent = t('pos.numpad.search');
        input.value = String(document.getElementById('searchInput').value || '');
      }
      if (action === 'customer') {
        title.textContent = state.language === 'tr' ? 'Müşteri Ara (Vergi No)' : 'Search Customer (Tax No)';
        input.value = String(document.getElementById('customerSearch').value || '');
      }
      if (action === 'lineQty') {
        title.textContent = state.language === 'tr' ? 'Miktar Düzenle' : 'Edit Quantity';
        input.value = String(document.getElementById('lineEditQty')?.value || '1');
      }
      if (action === 'lineDisc') {
        title.textContent = state.language === 'tr' ? 'Satır İndirimi (%)' : 'Line Discount (%)';
        input.value = String(document.getElementById('lineEditDisc')?.value || '0');
      }
      if (action === 'discount') {
        title.textContent = state.language === 'tr' ? 'İndirim Değeri Gir' : 'Enter Discount Value';
        input.value = String(document.getElementById('discountValue').value || '0');
      }
      if (action === 'barcode') {
        title.textContent = state.language === 'tr' ? 'Barkod Gir' : 'Enter Barcode';
        input.value = String(document.getElementById('barcodeInput').value || '');
      }

      modal.classList.remove('hidden');
      modal.classList.add('flex');
    }

    function closeKeypad() {
      const modal = document.getElementById('numpadModal');
      modal.classList.add('hidden');
      modal.classList.remove('flex');
      state.keypad.action = null;
      state.keypad.index = null;
    }

    function keypadAppend(value) {
      const input = document.getElementById('numpadInput');
      const cur = String(input.value || '');

      if (value === ',') {
        if (cur.includes(',')) return;
        input.value = cur.length ? (cur + ',') : '0,';
        return;
      }

      if (!/^[0-9]+$/.test(value)) return;

      if (cur === '0' || cur === '0,00') {
        input.value = value;
      } else {
        input.value = cur + value;
      }
    }

    function keypadBackspace() {
      const input = document.getElementById('numpadInput');
      const cur = String(input.value || '');
      if (state.keypad.action === 'search' || state.keypad.action === 'customer' || state.keypad.action === 'barcode') {
        input.value = cur.length ? cur.slice(0, -1) : '';
        return;
      }
      input.value = cur.length > 1 ? cur.slice(0, -1) : '0';
    }

    function keypadClear() {
      document.getElementById('numpadInput').value = (state.keypad.action === 'search' || state.keypad.action === 'customer' || state.keypad.action === 'barcode') ? '' : '0';
    }

    function keypadConfirm() {
      const inputVal = String(document.getElementById('numpadInput').value || '0');

      if (state.keypad.action === 'quantity' && state.keypad.index !== null) {
        const n = Math.max(1, Math.floor(parseTRNumber(inputVal)));
        state.cart[state.keypad.index].quantity = n;
        saveCart();
        renderCart();
        showToast(t('toast.updated'));
      }

      if (state.keypad.action === 'payment') {
        document.getElementById('paymentAmount').value = inputVal;
      }

      if (state.keypad.action === 'search') {
        document.getElementById('searchInput').value = inputVal;
        state.searchQuery = inputVal;
        renderProducts();
      }

      if (state.keypad.action === 'customer') {
        const el = document.getElementById('customerSearch');
        el.value = inputVal;
        el.dispatchEvent(new Event('input', { bubbles: true }));
      }

      if (state.keypad.action === 'discount') {
        document.getElementById('discountValue').value = inputVal;
        updateDiscountPreview();
      }

      if (state.keypad.action === 'lineQty') {
        const el = document.getElementById('lineEditQty');
        if (el) el.value = String(Math.max(1, Math.floor(parseTRNumber(inputVal))));
      }

      if (state.keypad.action === 'lineDisc') {
        const el = document.getElementById('lineEditDisc');
        if (el) el.value = String(Math.max(0, Math.min(100, parseTRNumber(inputVal))));
      }

      if (state.keypad.action === 'barcode') {
        const el = document.getElementById('barcodeInput');
        if (el) el.value = inputVal;
      }

      closeKeypad();
    }

    /* ===============================
       PAYMENT MODAL (CENTERED)
    ================================ */
    let paymentDockPlaceholder = null;
    let paymentFullPlaceholder = null;

    function openPaymentModal() {
      const paymentModal = document.getElementById('paymentModal');
      const paymentModalBody = document.getElementById('paymentModalBody');
      const paymentDock = document.getElementById('paymentDock');
      const paymentFullArea = document.getElementById('paymentFullArea');
      const paymentPageTotal = document.getElementById('paymentPageTotal');

      if (!paymentModal || !paymentModalBody || !paymentDock || !paymentFullArea) return;
      if (!paymentModal.classList.contains('hidden')) return;

      if (paymentPageTotal) paymentPageTotal.textContent = document.getElementById('total')?.textContent || '0.00 ₺';

      paymentDockPlaceholder = document.createElement('div');
      paymentDockPlaceholder.id = 'paymentDockPlaceholder';
      paymentDockPlaceholder.style.minHeight = '1px';
      paymentDock.parentNode.replaceChild(paymentDockPlaceholder, paymentDock);

      paymentFullPlaceholder = document.createElement('div');
      paymentFullPlaceholder.id = 'paymentFullPlaceholder';
      paymentFullPlaceholder.style.minHeight = '1px';
      paymentFullArea.parentNode.replaceChild(paymentFullPlaceholder, paymentFullArea);

      paymentDock.classList.add('in-modal');
      paymentFullArea.classList.add('in-modal');

      paymentModalBody.innerHTML = '';
      paymentModalBody.appendChild(paymentDock);
      paymentModalBody.appendChild(paymentFullArea);

      paymentModal.classList.remove('hidden');
    }

    function closePaymentModal() {
      const paymentModal = document.getElementById('paymentModal');
      const paymentModalBody = document.getElementById('paymentModalBody');
      const paymentDock = document.getElementById('paymentDock');
      const paymentFullArea = document.getElementById('paymentFullArea');

      if (!paymentModal || !paymentModalBody || !paymentDock || !paymentFullArea) return;
      paymentModal.classList.add('hidden');

      if (paymentDock.parentNode === paymentModalBody) paymentModalBody.removeChild(paymentDock);
      if (paymentFullArea.parentNode === paymentModalBody) paymentModalBody.removeChild(paymentFullArea);

      paymentDock.classList.remove('in-modal');
      paymentFullArea.classList.remove('in-modal');

      if (paymentDockPlaceholder && paymentDockPlaceholder.parentNode) {
        paymentDockPlaceholder.parentNode.replaceChild(paymentDock, paymentDockPlaceholder);
        paymentDockPlaceholder = null;
      }
      if (paymentFullPlaceholder && paymentFullPlaceholder.parentNode) {
        paymentFullPlaceholder.parentNode.replaceChild(paymentFullArea, paymentFullPlaceholder);
        paymentFullPlaceholder = null;
      }
    }

    /* ===============================
       TOAST
    ================================ */
    function showToast(message, isError=false) {
      const toast = document.getElementById('toast');
      const msg = document.getElementById('toastMessage');
      msg.textContent = message;
      toast.classList.remove('hidden');
      toast.classList.toggle('bg-green-500', !isError);
      toast.classList.toggle('bg-red-500', !!isError);
      setTimeout(() => toast.classList.add('hidden'), 2200);
    }

    /* ===============================
       SIDEBAR
    ================================ */
    function setSidebarOpen(open) {
      const sidebar = document.getElementById('sidebar');
      const overlay = document.getElementById('sidebarOverlay');
      sidebar.classList.toggle('open', !!open);
      overlay.classList.toggle('hidden', !open);
      localStorage.setItem('pos_sidebar', open ? '1' : '0');
    }

    /* ===============================
       INIT + EVENTS
    ================================ */
    document.addEventListener('DOMContentLoaded', () => {
      loadProducts();
      applyTheme();
      applyLanguage();
      setReorderUI(state.reorderMode);
      const savedSidebar = localStorage.getItem('pos_sidebar');
      const startOpen = savedSidebar === null ? false : savedSidebar === '1';
      setSidebarOpen(startOpen);

      renderCategoryTabs();
      renderProducts();
      renderCart();

      // Menu toggle
      document.getElementById('menuToggle').addEventListener('click', () => {
        const isOpen = document.getElementById('sidebar').classList.contains('open');
        setSidebarOpen(!isOpen);
      });
      document.getElementById('sidebarOverlay').addEventListener('click', () => setSidebarOpen(false));

      // Language
      document.getElementById('langTR').addEventListener('click', () => { state.language = 'tr'; applyLanguage(); });
      document.getElementById('langEN').addEventListener('click', () => { state.language = 'en'; applyLanguage(); });

      // Theme
      document.querySelectorAll('.theme-btn').forEach(btn => {
        btn.addEventListener('click', (e) => {
          state.theme = e.currentTarget.dataset.theme;
          applyTheme();
        });
      });

      // Accent dropdown
      const accentDropdownBtn = document.getElementById('accentDropdownBtn');
      const accentDropdown = document.getElementById('accentDropdown');
      accentDropdownBtn.addEventListener('click', (e) => {
        e.stopPropagation();
        accentDropdown.classList.toggle('hidden');
      });
      document.addEventListener('click', () => accentDropdown.classList.add('hidden'));
      accentDropdown.querySelectorAll('button[data-accent]').forEach(btn => {
        btn.addEventListener('click', (e) => {
          e.stopPropagation();
          state.accent = e.currentTarget.dataset.accent;
          applyTheme();
          accentDropdown.classList.add('hidden');
        });
      });

      // User dropdown
      const userBtn = document.getElementById('userMenuBtn');
      const userMenu = document.getElementById('userMenu');
      userBtn.addEventListener('click', (e) => {
        e.stopPropagation();
        userMenu.classList.toggle('hidden');
      });
      document.addEventListener('click', () => userMenu.classList.add('hidden'));
      document.getElementById('profileBtn').addEventListener('click', () => alert(state.language === 'tr' ? 'Profil ekranı (UI)' : 'Profile (UI)'));
      document.getElementById('logoutBtn').addEventListener('click', () => { window.location.href = '/logout.php'; });

      // Search
      const searchInput = document.getElementById('searchInput');
      searchInput.addEventListener('input', () => {
        state.searchQuery = searchInput.value;
        renderProducts();
      });
      searchInput.addEventListener('dblclick', () => openKeypad('search'));

      // Barcode input
      const barcodeInput = document.getElementById('barcodeInput');
      barcodeInput?.addEventListener('keydown', (e) => {
        if (e.key !== 'Enter') return;
        e.preventDefault();
        const code = (barcodeInput.value || '').trim();
        if (!code) return;
        const product = state.products.find(p => String(p.barcode || '') === code);
        if (product) {
          addToCart(product);
          barcodeInput.value = '';
          showToast(state.language === 'tr' ? 'Barkod eklendi' : 'Added by barcode');
        } else {
          showToast(state.language === 'tr' ? 'Ürün bulunamadı' : 'Product not found');
        }
      });
      // Barkod alanına çift tıklama
      barcodeInput?.addEventListener('dblclick', () => openKeypad('barcode'));

      // Payment modal
      document.getElementById('paymentCompactBtn')?.addEventListener('click', openPaymentModal);
      document.getElementById('paymentModalClose')?.addEventListener('click', closePaymentModal);
      document.getElementById('paymentModal')?.addEventListener('click', (e) => {
        if (e.target.id === 'paymentModal') closePaymentModal();
      });

      // Add product button
      document.getElementById('addProductBtn').addEventListener('click', () => openProductEditModal(null, true));

      // Product edit modal
      document.getElementById('closeProductEditModal').addEventListener('click', closeProductEditModal);
      document.getElementById('cancelProductEdit').addEventListener('click', closeProductEditModal);
      document.getElementById('saveProductEdit').addEventListener('click', saveProductEdit);
      document.getElementById('deleteProductBtn').addEventListener('click', deleteProduct);
      document.getElementById('productEditModal').addEventListener('click', (e) => {
        if (e.target.id === 'productEditModal') closeProductEditModal();
      });

      // Payment amount click -> keypad
      document.getElementById('paymentAmount')?.addEventListener('click', () => openKeypad('payment'));

      // Payment buttons
      document.querySelectorAll('.payment-btn').forEach(btn => {
        btn.addEventListener('click', (e) => {
          const type = e.currentTarget.dataset.pay;
          alert(state.language === 'tr' ? `${type} ödemesi (demo)` : `${type} payment (demo)`);
        });
      });

      // Action buttons
      document.getElementById('holdBtn')?.addEventListener('click', () => {
        if (state.cart.length === 0) {
          showToast(state.language === 'tr' ? 'Sepet boş!' : 'Cart is empty!', true);
          return;
        }
        alert(state.language === 'tr' ? 'Fiş bekletildi (demo)' : 'Receipt held (demo)');
        state.cart = [];
        saveCart();
        renderCart();
        showToast(t('toast.held'));
      });

      document.getElementById('cancelBtn')?.addEventListener('click', () => {
        if (state.cart.length === 0) return;
        if (confirm(state.language === 'tr' ? 'Sepeti temizlemek istediğinize emin misiniz?' : 'Clear cart?')) {
          state.cart = [];
          saveCart();
          renderCart();
          showToast(state.language === 'tr' ? 'Sepet temizlendi' : 'Cart cleared');
        }
      });

      document.getElementById('printBtn')?.addEventListener('click', () => {
        if (state.cart.length === 0) {
          showToast(state.language === 'tr' ? 'Sepet boş!' : 'Cart is empty!', true);
          return;
        }
        alert(state.language === 'tr' ? 'Fiş yazdırıldı (demo)' : 'Receipt printed (demo)');
      });

      document.getElementById('discountBtn')?.addEventListener('click', openDiscountModal);

      // Discount modal events
      document.getElementById('discountPercent')?.addEventListener('click', () => {
        state.discount.type = 'percent';
        document.getElementById('discountPercent').classList.add('bg-[var(--primary)]', 'text-white');
        document.getElementById('discountPercent').classList.remove('bg-[var(--surface)]');
        document.getElementById('discountAmount').classList.remove('bg-[var(--primary)]', 'text-white');
        document.getElementById('discountAmount').classList.add('bg-[var(--surface)]');
        updateDiscountPreview();
      });

      document.getElementById('discountAmount')?.addEventListener('click', () => {
        state.discount.type = 'amount';
        document.getElementById('discountAmount').classList.add('bg-[var(--primary)]', 'text-white');
        document.getElementById('discountAmount').classList.remove('bg-[var(--surface)]');
        document.getElementById('discountPercent').classList.remove('bg-[var(--primary)]', 'text-white');
        document.getElementById('discountPercent').classList.add('bg-[var(--surface)]');
        updateDiscountPreview();
      });

      document.getElementById('discountValue')?.addEventListener('click', () => openKeypad('discount'));
      document.getElementById('removeDiscount')?.addEventListener('click', removeDiscount);
      document.getElementById('applyDiscount')?.addEventListener('click', applyDiscount);
      document.getElementById('closeDiscountModal')?.addEventListener('click', closeDiscountModal);
      document.getElementById('discountModal')?.addEventListener('click', (e) => {
        if (e.target.id === 'discountModal') closeDiscountModal();
      });

      // Customer search and modal
      const customerSearch = document.getElementById('customerSearch');
      customerSearch?.addEventListener('input', (e) => {
        const value = e.target.value;
        if (value.length > 0) {
          renderCustomerDropdown(value);
        } else {
          document.getElementById('customerDropdown').classList.add('hidden');
        }
      });

      customerSearch?.addEventListener('dblclick', () => openKeypad('customer'));

      document.getElementById('newCustomerBtn')?.addEventListener('click', openCustomerModal);
      document.getElementById('clearCustomer')?.addEventListener('click', clearCurrentCustomer);

      // Customer modal events
      document.getElementById('closeCustomerModal')?.addEventListener('click', closeCustomerModal);
      document.getElementById('cancelCustomer')?.addEventListener('click', closeCustomerModal);
      document.getElementById('saveCustomer')?.addEventListener('click', saveCustomer);
      document.getElementById('customerModal')?.addEventListener('click', (e) => {
        if (e.target.id === 'customerModal') closeCustomerModal();
      });

      // Close customer dropdown when clicking outside
      document.addEventListener('click', (e) => {
        if (!e.target.closest('#customerSearch') && !e.target.closest('#customerDropdown')) {
          document.getElementById('customerDropdown').classList.add('hidden');
        }
      });

      // Line edit modal
      document.getElementById('lineEditClose')?.addEventListener('click', closeLineEdit);
      document.getElementById('lineEditModal')?.addEventListener('click', (e) => { if (e.target?.id === 'lineEditModal') closeLineEdit(); });
      document.getElementById('lineEditQty')?.addEventListener('dblclick', () => openKeypad('lineQty'));
      document.getElementById('lineEditDisc')?.addEventListener('dblclick', () => openKeypad('lineDisc'));
      document.getElementById('lineEditRemoveDisc')?.addEventListener('click', () => { const el = document.getElementById('lineEditDisc'); if (el) el.value = '0'; });
      document.getElementById('lineEditSave')?.addEventListener('click', saveLineEdit);

      // Keyboard shortcuts (F1, F2, F3)
      document.addEventListener('keydown', (e) => {
        if (e.key === 'F1' && state.cart.length > 0) {
          e.preventDefault();
          document.querySelector('[data-pay="cash"]')?.click();
        }
        if (e.key === 'F2' && state.cart.length > 0) {
          e.preventDefault();
          document.querySelector('[data-pay="card"]')?.click();
        }
        if (e.key === 'F3' && state.cart.length > 0) {
          e.preventDefault();
          document.getElementById('holdBtn')?.click();
        }
        if (e.key === 'Escape') {
          closeKeypad();
          closePaymentModal();
          closeDiscountModal();
          closeCustomerModal();
          closeLineEdit();
          closeProductEditModal();
        }
        if (e.key === '/' && !e.target.matches('input, textarea')) {
          e.preventDefault();
          document.getElementById('searchInput').focus();
        }
      });

      // Keypad buttons
      document.querySelectorAll('.numpad-key').forEach(key => {
        key.addEventListener('click', (e) => {
          const btn = e.currentTarget;
          if (btn.dataset.key === 'enter') {
            keypadConfirm();
            return;
          }
          const value = btn.textContent.trim();
          keypadAppend(value);
        });
      });
      document.getElementById('numpadBackspace').addEventListener('click', keypadBackspace);
      document.getElementById('numpadClear').addEventListener('click', keypadClear);
      document.getElementById('numpadCancel').addEventListener('click', closeKeypad);
      document.getElementById('numpadCloseX').addEventListener('click', closeKeypad);
      document.getElementById('numpadConfirm').addEventListener('click', keypadConfirm);

      // Reorder toggle
      document.getElementById('reorderToggle').addEventListener('change', (e) => {
        state.reorderMode = e.currentTarget.checked;
        setReorderUI(state.reorderMode);
        renderProducts();
      });
    });
  </script>
</body>
</html>