<?php
declare(strict_types=1);

require __DIR__ . '/../app/helpers.php';

session_start_safe();

$items = get_items();
$format = strtolower((string)($_GET['format'] ?? 'csv'));
if (!in_array($format, ['csv', 'xls'], true)) {
  $format = 'csv';
}

$ts = date('Y-m-d_H-i');
$filename = 'stok_kodlari_' . $ts . ($format === 'xls' ? '.xls' : '.csv');

$rows = [];
$rows[] = ['Stok Kodu', 'Stok Adı', 'Fiyat', 'Barkod', 'Birim', 'Tarih'];
foreach ($items as $it) {
  $rows[] = [
    (string)($it['code'] ?? ''),
    (string)($it['name'] ?? ''),
    (string)($it['price'] ?? ''),
    (string)($it['barcode'] ?? ''),
    (string)($it['unit'] ?? ''),
    (string)($it['created_at'] ?? ''),
  ];
}

if ($format === 'xls') {
  header('Content-Type: application/vnd.ms-excel; charset=UTF-8');
  header('Content-Disposition: attachment; filename="' . $filename . '"');
  echo "<html><head><meta charset=\"utf-8\"></head><body>";
  echo "<table border=\"1\">";
  foreach ($rows as $r) {
    echo '<tr>';
    foreach ($r as $cell) {
      echo '<td>' . htmlspecialchars((string)$cell, ENT_QUOTES | ENT_SUBSTITUTE, 'UTF-8') . '</td>';
    }
    echo '</tr>';
  }
  echo "</table></body></html>";
  exit;
}

// CSV (Excel friendly): UTF-8 BOM + semicolon delimiter
header('Content-Type: text/csv; charset=UTF-8');
header('Content-Disposition: attachment; filename="' . $filename . '"');

$output = fopen('php://output', 'w');
if ($output === false) {
  http_response_code(500);
  echo "Cannot open output";
  exit;
}

// UTF-8 BOM for Excel
fwrite($output, "\xEF\xBB\xBF");

foreach ($rows as $r) {
  fputcsv($output, $r, ';');
}

fclose($output);
exit;
